package com.elitesland.fin.entity.financial;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2025/10/14 10:29
 */
@Entity
@Table(name = "financial_bill")
@org.hibernate.annotations.Table(appliesTo = "financial_bill", comment = "账单")
@Data
@Where(clause = "delete_flag = 0")
@ApiModel(value = "financial_bill", description = "账单")
public class FinancialBillDO extends BaseModel implements Serializable {

    // 流程信息
    @Column
    @ApiModelProperty("流程ID")
    private String msyWorkId;
    @Column
    @ApiModelProperty("流程名称")
    private String msyWorkName;
    @Column
    @ApiModelProperty("数据ID")
    private String msyDataId;
    @Column
    @ApiModelProperty("支付节点ID")
    private String msyPayNodeId;
    // 基础信息
    @Column
    @ApiModelProperty("门店名称")
    private String storeName;
    @Column
    @ApiModelProperty("门店编码")
    private String storeCode;
    @Column
    @ApiModelProperty("外部门店ID")
    private String outerStoreId;
    @Column
    @ApiModelProperty("单据类型")
    private String docType;
    @Column
    @ApiModelProperty("关联门店(项目)")
    private String msyStoreId;

    @Column
    @ApiModelProperty("经营性质")
    private String storeType;

    @Column
    @ApiModelProperty("外部加盟商ID")
    private String msyFranchiseeId;

    @Column
    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @Column
    @ApiModelProperty("加盟商名称")
    private String franchiseeName;

    @Column
    @ApiModelProperty("项目编码")
    private String projectNumber;

    @Column
    @ApiModelProperty("支付方式")
    private String paymentChannel;

    @Column
    @ApiModelProperty("账单ID")
    private String payOrderId;

    @Column
    @ApiModelProperty("交易流水号（天财商龙）")
    private String orderIdTt;

    @Column
    @ApiModelProperty("交易流水号（微企付）")
    private String orderIdWqf;

    @Column
    @ApiModelProperty("收款账户id（天财商龙）")
    private String receivingAccountTt;

    @Column
    @ApiModelProperty("收款账户（钱包分账）")
    private String receivingAccountQb;

    @Column
    @ApiModelProperty("收款公司")
    private String ouCode;

    @Column
    @ApiModelProperty("收款账号")
    private String receivingAccount;

    @Column
    @ApiModelProperty("收款方户名")
    private String receivingAccountName;

    @Column
    @ApiModelProperty("付款账户（钱包分账）")
    private String paymentAccountQb;

    @Column
    @ApiModelProperty("付款人")
    private String paymentAccountName;

    @Column
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAccountAmount;

    @Column
    @ApiModelProperty("账单完成时间")
    private LocalDateTime paymentDate;

    @Column
    @ApiModelProperty("付款凭证附件URL")
    private String url;

    @Column
    @ApiModelProperty("附件名称")
    private String fileName;

    @Column
    @ApiModelProperty("红冲来源")
    private String redSource;

    @Column
    @ApiModelProperty("拟定状态")
    private String draftStatus;

    @Column
    @ApiModelProperty("红冲状态")
    private String redStatus;

    @Column
    @ApiModelProperty("传账状态")
    private String postingStatus;
}
