package com.elitesland.fin.repo.financial;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.entity.financial.QFinancialBillDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:30
 */
@Component
@RequiredArgsConstructor
public class FinancialBillRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QFinancialBillDO qFinancialBillDO = QFinancialBillDO.financialBillDO;

    public PagingVO<FinancialBillDTO> page(FinancialBillPageParam financialBillPageParam) {
        List<Predicate> where = where(financialBillPageParam);
        JPAQuery<FinancialBillDTO> query = select(FinancialBillDTO.class).where(ExpressionUtils.allOf(where));
        financialBillPageParam.setPaging(query);
        financialBillPageParam.fillOrders(query, qFinancialBillDO);
        return PagingVO.<FinancialBillDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> where(FinancialBillPageParam financialBillPageParam) {
        List<Predicate> predicates = new ArrayList<>();
        if (!CollectionUtils.isEmpty(financialBillPageParam.getIds())) {
            predicates.add(qFinancialBillDO.id.in(financialBillPageParam.getIds()));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getMsyWorkId())) {
            predicates.add(qFinancialBillDO.msyWorkId.like("%"+financialBillPageParam.getMsyWorkId()+"%"));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getMsyStoreId())) {
            predicates.add(qFinancialBillDO.msyStoreId.like("%"+financialBillPageParam.getMsyStoreId()+"%"));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getFranchiseeCode())) {
            predicates.add(qFinancialBillDO.franchiseeCode.like("%"+financialBillPageParam.getFranchiseeCode()+"%"));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getDocType())) {
            predicates.add(qFinancialBillDO.docType.eq(financialBillPageParam.getDocType()));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getStoreType())) {
            predicates.add(qFinancialBillDO.storeType.eq(financialBillPageParam.getStoreType()));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getStoreCode())) {
            predicates.add(qFinancialBillDO.storeCode.eq(financialBillPageParam.getStoreCode()));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getOuCode())) {
            predicates.add(qFinancialBillDO.ouCode.eq(financialBillPageParam.getOuCode()));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getDraftStatus())) {
            predicates.add(qFinancialBillDO.draftStatus.eq(financialBillPageParam.getDraftStatus()));
        }
        if (!StringUtils.isEmpty(financialBillPageParam.getPostingStatus())) {
            predicates.add(qFinancialBillDO.postingStatus.eq(financialBillPageParam.getPostingStatus()));
        }
        if (financialBillPageParam.getCreateTimeStart()!=null) {
            predicates.add(qFinancialBillDO.createTime.goe(financialBillPageParam.getCreateTimeStart()));
        }
        if (financialBillPageParam.getCreateTimeEnd()!=null) {
            predicates.add(qFinancialBillDO.createTime.loe(financialBillPageParam.getCreateTimeEnd()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinancialBillDO.id,
                qFinancialBillDO.modifyTime,
                qFinancialBillDO.modifyUserId,
                qFinancialBillDO.updater,
                qFinancialBillDO.createTime,
                qFinancialBillDO.createUserId,
                qFinancialBillDO.remark,
                qFinancialBillDO.deleteFlag,
                qFinancialBillDO.tenantId,
                qFinancialBillDO.tenantOrgId,
                qFinancialBillDO.secBuId,
                qFinancialBillDO.secOuId,
                qFinancialBillDO.secUserId,
                qFinancialBillDO.belongOrgId,
                qFinancialBillDO.auditDataVersion,
                qFinancialBillDO.msyWorkId,
                qFinancialBillDO.msyWorkName,
                qFinancialBillDO.msyDataId,
                qFinancialBillDO.msyPayNodeId,
                qFinancialBillDO.storeName,
                qFinancialBillDO.storeCode,
                qFinancialBillDO.outerStoreId,
                qFinancialBillDO.docType,
                qFinancialBillDO.msyStoreId,
                qFinancialBillDO.storeType,
                qFinancialBillDO.msyFranchiseeId,
                qFinancialBillDO.franchiseeCode,
                qFinancialBillDO.franchiseeName,
                qFinancialBillDO.projectNumber,
                qFinancialBillDO.paymentChannel,
                qFinancialBillDO.payOrderId,
                qFinancialBillDO.orderIdTt,
                qFinancialBillDO.orderIdWqf,
                qFinancialBillDO.receivingAccountTt,
                qFinancialBillDO.receivingAccountQb,
                qFinancialBillDO.ouCode,
                qFinancialBillDO.receivingAccount,
                qFinancialBillDO.receivingAccountName,
                qFinancialBillDO.paymentAccountQb,
                qFinancialBillDO.paymentAccountName,
                qFinancialBillDO.paymentAccountAmount,
                qFinancialBillDO.paymentDate,
                qFinancialBillDO.url,
                qFinancialBillDO.fileName,
                qFinancialBillDO.redSource,
                qFinancialBillDO.draftStatus,
                qFinancialBillDO.redStatus,
                qFinancialBillDO.postingStatus
        )).from(qFinancialBillDO);
    }

}
