package com.elitesland.fin.repo.flow;

import com.elitesland.fin.entity.flow.AccountFlowDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Repository
public interface AccountFlowRepo extends JpaRepository<AccountFlowDO, Long>, QuerydslPredicateExecutor<AccountFlowDO> {

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update account_flow set delete_flag = 1 where flow_no in ?1", nativeQuery = true)
    void deleteByFlowNos(List<String> flowNos);

}
