/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.financial;

import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.convert.financial.FinancialBillDConvert;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDSaveParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.application.service.financial.FinancialBillService;
import com.elitesland.fin.domain.service.financial.FinancialBillDDomainService;
import com.elitesland.fin.domain.service.financial.FinancialBillDomainService;
import com.elitesland.fin.entity.financial.FinancialBillDDO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FinancialBillServiceImpl
implements FinancialBillService {
    private static final Logger log = LoggerFactory.getLogger(FinancialBillServiceImpl.class);
    private final FinancialBillDomainService financialBillDomainService;
    private final FinancialBillDDomainService financialBillDDomainService;
    private final SysUdcProxyService sysUdcProxyService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @SysCodeProc
    public PagingVO<FinancialBillVO> pageSearch(FinancialBillPageParam financialBillPageParam) {
        PagingVO<FinancialBillVO> financialBillVOPagingVO = FinancialBillConvert.INSTANCE.convertPage(this.financialBillDomainService.page(financialBillPageParam));
        List<String> ouCodes = financialBillVOPagingVO.getRecords().stream().map(FinancialBillVO::getOuCode).collect(Collectors.toList());
        Map<String, String> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(ouCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, OrgOuRpcSimpleDTO::getOuName));
        financialBillVOPagingVO.getRecords().forEach(vo -> {
            if (ouMap.get(vo.getOuCode()) != null) {
                vo.setOuName((String)ouMap.get(vo.getOuCode()));
            }
        });
        return financialBillVOPagingVO;
    }

    @Override
    @SysCodeProc
    public FinancialBillVO get(Long id) {
        FinancialBillDTO financialBillDTO = this.financialBillDomainService.get(id);
        List<FinancialBillDDTO> financialBillDDTOS = this.financialBillDDomainService.queryByMasId(id);
        this.sysUdcProxyService.translate(financialBillDDTOS);
        financialBillDTO.setFinancialBillDList(financialBillDDTOS);
        return FinancialBillConvert.INSTANCE.dtoToVo(financialBillDTO);
    }

    @Override
    @Transactional
    public void batchSaveFinancialBill(List<FinancialBillSaveParam> param) {
        if (!CollectionUtils.isEmpty(param)) {
            ArrayList<FinancialBillDDO> dtlData = new ArrayList<FinancialBillDDO>();
            param.forEach(vo -> {
                FinancialBillDO financialBillDO = FinancialBillConvert.INSTANCE.saveToDos((FinancialBillSaveParam)vo);
                Long save = this.financialBillDomainService.save(financialBillDO);
                vo.getFinancialBillDList().forEach(dtl -> {
                    FinancialBillDDO financialBillDDO = FinancialBillDConvert.INSTANCE.paramToDO((FinancialBillDSaveParam)dtl);
                    financialBillDDO.setMasId(save);
                    dtlData.add(financialBillDDO);
                });
            });
            if (!CollectionUtils.isEmpty(dtlData)) {
                this.financialBillDDomainService.batchSaveFinancialBillD(dtlData);
            }
        }
    }

    public FinancialBillServiceImpl(FinancialBillDomainService financialBillDomainService, FinancialBillDDomainService financialBillDDomainService, SysUdcProxyService sysUdcProxyService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.financialBillDomainService = financialBillDomainService;
        this.financialBillDDomainService = financialBillDDomainService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

