package com.elitesland.fin.application.convert.financial;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDSaveParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillDVO;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.entity.financial.FinancialBillDDO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @date 2022/3/16 16:14
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface FinancialBillDConvert {

    FinancialBillDConvert INSTANCE = Mappers.getMapper(FinancialBillDConvert.class);


    List<FinancialBillDVO> dtoToVo(List<FinancialBillDDTO> financialBillDTOList);

    List<FinancialBillDDTO> doToDto(List<FinancialBillDDO> financialBillDOList);

    PagingVO<FinancialBillDVO> convertPage(PagingVO<FinancialBillDDTO> param);

    FinancialBillDDO paramToDO(FinancialBillDSaveParam financialBillDSaveParam);
}
