package com.elitesland.fin.application.service.writeoff;


import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecVO;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinArRecVerApplyRecService {

    /**
     * 批量插入.
     *
     * @param masId    主表ID
     * @param saveList 数据集合
     */
    void createBatch(Long masId, List<FinArRecVerApplyRecSaveDTO> saveList);

    /**
     * 批量删除.
     *
     * @param masIds 主表ID集合
     */
    void deleteByMasId(Collection<Long> masIds);

    /**
     * 数据查询.
     *
     * @param masIds 主表ID集合
     * @return 数据集合
     */
    List<FinArRecVerApplyRecVO> listByMasIds(Collection<Long> masIds);

	/**
	 * 根据条件查询核销收款单明细
	 * @param query
	 * @return
	 */
	List<FinArRecVerApplyRecVO> listByQuery(FinArRecVerApplyRecQuery query);

	/**
	 * 通过第三方收款单号或者明细ID查询
	 * @param query
	 * @return
	 */
	List<FinArRecVerApplyRecVO> listByOutRecDocNoOrDId(FinArRecVerApplyQuery query);
}
