package com.elitesland.fin.application.web.expense;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpTypeParam;
import com.elitesland.fin.application.facade.vo.expense.ExpTypeVO;
import com.elitesland.fin.application.service.expense.ExpTypeService;
import com.elitesland.fin.domain.param.expense.ExpTypePageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/8 10:09
 * @Description:
 */
@RestController
@RequestMapping("/fin/expense/type")
@RequiredArgsConstructor
@Api(value = "费用类型", tags = {"费用类型配置"})
public class ExpenseTypeController {
    private final ExpTypeService expTypeService;

    @PostMapping("save")
    @ApiOperation("新增费用类型配置")
    public ApiResult<Long> save(@RequestBody ExpTypeParam expTypeParam) {
        ApiResult<Long> save = expTypeService.save(expTypeParam);
        return save;
    }

    @PostMapping("update")
    @ApiOperation("修改费用类型")
    public ApiResult<Long> update(@RequestBody ExpTypeParam expTypeParam) {
        ApiResult<Long> save = expTypeService.update(expTypeParam);
        return save;
    }


    @GetMapping("get")
    @ApiOperation("获取费用类型详情")
    public ApiResult<ExpTypeVO> get(Long id) {
        ApiResult<ExpTypeVO> res = expTypeService.get(id);
        return res;
    }

    @GetMapping("getList")
    @ApiOperation("获取启用状态的费用类型")
    public ApiResult<List<ExpTypeVO>> getList() {
        return expTypeService.getList();
    }

    @PostMapping("page")
    @ApiOperation("费用类型分页列表")
    public ApiResult<PagingVO<ExpTypeVO>> page(@RequestBody ExpTypePageParam expTypePageParam) {
        ApiResult<PagingVO<ExpTypeVO>> page = expTypeService.page(expTypePageParam);
        return page;
    }

    @PostMapping("enable")
    @ApiOperation("启用/状态批量修改")
    public ApiResult<Boolean> enable(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = expTypeService.updateEnableFlag(ids, true);
        return res;
    }

    @PostMapping("stop")
    @ApiOperation("停用/状态批量修改")
    public ApiResult<Boolean> stop(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = expTypeService.updateEnableFlag(ids, false);
        return res;
    }

    @DeleteMapping("del/{id}")
    @ApiOperation("删除应费用类型")
    public ApiResult<Long> del(@PathVariable("id") Long id) {
        ApiResult<Long> res = expTypeService.del(id);
        return res;
    }
}
