package com.elitesland.fin.application.web.financial;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDPageParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillDVO;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.application.service.financial.FinancialBillDService;
import com.elitesland.fin.application.service.financial.FinancialBillService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * @author Karl.wang
 * @version V1.0
 * @Package com.elitesland.fin.application.web.aporder
 * @date 2022/3/16 16:08
 */
@RestController
@RequestMapping("/fin/financialBill")
@RequiredArgsConstructor
@Api(value = "账单", tags = {"账单"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_BILL, businessDoClass = FinancialBillDO.class)
public class FinancialBillController {

    private final FinancialBillService financialBillService;
    private final FinancialBillDService financialBillDService;

    @PostMapping("/page")
    @ApiOperation("账单分页查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "账单分页查询",
            businessObjectType = FinBusinessObjectConstant.FIN_BILL, operationCode = FinBusinessObjectConstant.FIN_BILL_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<FinancialBillVO>> page(@RequestBody FinancialBillPageParam financialBillPageParam) {
        return ApiResult.ok(financialBillService.pageSearch(financialBillPageParam));
    }

    @GetMapping("/detail/{id}")
    @ApiOperation("账单详情")
    public ApiResult<FinancialBillVO> get(@PathVariable("id") Long id) {
        return ApiResult.ok(financialBillService.get(id));
    }

    @PostMapping("/dtl/page")
    @ApiOperation("分页查询账单明细")
    public ApiResult<PagingVO<FinancialBillDVO>> pageDtl(@RequestBody FinancialBillDPageParam financialBillPageParam) {
        return ApiResult.ok(financialBillDService.pageSearch(financialBillPageParam));
    }

}
