package com.elitesland.fin.domain.param.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel("IPV计算参数")
public class IpvInvoiceComputeParam implements Serializable {
    private static final long serialVersionUID = 6284754236392722602L;

    @ApiModelProperty("库存会计期间")
    @NotNull(message = "库存会计期间不能为空")
    private String buDate;

    @ApiModelProperty("公司编码")
    @NotBlank(message = "公司编码")
    private String ouCode;

}
