package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.domain.entity.accountingengine.FinAbstractDetailDO;
import com.google.common.collect.Lists;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinAbstractDetailRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinAbstractDetailRepo finAbstractDetailRepo;

    public List<FinAbstractDetailDO> findByMasIdIn(List<Long> masIdList) {
        if(CollectionUtils.isEmpty(masIdList)){
            return Lists.newArrayList();
        }

        List<FinAbstractDetailDO> abstractDetailDOList = finAbstractDetailRepo.findAllByMasIdIn(masIdList);
        Assert.notEmpty(abstractDetailDOList,"查不到组合设置明细");

        return abstractDetailDOList;
    }
}
