package com.elitesland.fin.application.facade.vo.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "待开发票返回实体")
public class InvoiceAwaitRespVO implements Serializable {
    private static final long serialVersionUID = 2617718744779453725L;


    @ApiModelProperty("明细表ID")
    private Long id;

    @ApiModelProperty("付款记录表头ID")
    private Long masId;

    @ApiModelProperty("明细行号")
    private Integer lineNo;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("税收分类编码")
    private String taxType;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String serviceName;

    @ApiModelProperty("规格")
    private String itemSpec;

    @ApiModelProperty(value = "基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal originAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("(开票申请金额)")
    private BigDecimal totalAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal tax;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("待开发票单号")
    private String docNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("待开发票状态")
    private String invoiceAwaitStatus;

    @ApiModelProperty("来源单据")
    private String optDocType;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("发票文件编码")
    private String invoiceFileCode;

    @ApiModelProperty("开票申请单号")
    private String invoiceApplyNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("来源单据名称")
    private String optDocCls;

    @ApiModelProperty("来源单据ID")
    private Long optDocId;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-fin", mod = "PAYMENT_STATUS")
    private String paymentStatus;
    private String paymentStatusName;

    /**
     * 开户银行
     */
    @ApiModelProperty(name = "开户银行")
    private String invBankNo;
    /**
     * 银行账号
     */
    @ApiModelProperty(name = "银行账号")
    private String bankAccount;
    @ApiModelProperty(name = "收费项目名称")
    private String itemCodeName;

    @ApiModelProperty(name = "实收金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty(name = "税额")
    private BigDecimal taxAmt;

    /**
     * 日期
     */
    @ApiModelProperty(name = "通知日期")
    private LocalDate noticeDate;

    @ApiModelProperty(name = "付款日期")
    private LocalDate paymentDate;

    @ApiModelProperty(name = "通知id")
    private Long noticeId;

    /**
     * 通知内容
     */
    @ApiModelProperty(name = "通知内容")
    private String noticeContent;

    @ApiModelProperty(name = "联行号")
    private String uniBankNo;

    @ApiModelProperty(name = "付款凭证编码")
    private String voucherFileCode;

    @ApiModelProperty("门店ID")
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("来源单据类型")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDocType;
    private String sourceDocTypeName;

    @ApiModelProperty("来源单据ID")
    private Long sourceDocId;

    @ApiModelProperty("来源单据单号")
    private String sourceDocNo;

    @ApiModelProperty("是否参与开票")
    @SysCode(sys = "yst-fin", mod = "IS_BILLING")
    private String isToBilling;

    @ApiModelProperty("是否参与开票中文")
    private String isToBillingName;

    @ApiModelProperty("开票详情")
    private String invoiceInfo;

    @ApiModelProperty("付款银行")
    private String payBank;
    @ApiModelProperty("付款账户")
    private String payAccount;
    @ApiModelProperty("付款类型")
    @SysCode(sys = "yst-fin",mod = "PAY_METHOD")
    private String payType;
    private String payTypeName;

    @ApiModelProperty(value = "开票申请是否自动审核 ture-是 false-否")
    private Boolean autoReview;

    @ApiModelProperty(value = "是否自动开票 ture-是 false-否")
    private Integer autoInvoice;

    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    private BigDecimal invAmt;

    @ApiModelProperty("发货/收货单明细id")
    private Long relateDocDid;

    @ApiModelProperty("发货/收货单单号")
    private String relateDocNo;

    @ApiModelProperty("来源单据明细表ID")
    private Long optDocDtlId;

    @ApiModelProperty("发货日期")
    private LocalDateTime shipTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("销/退订单号")
    private String logisDocNo;

    @ApiModelProperty("订单类型")
    private String relateDocType;

    @ApiModelProperty("订单日期")
    private LocalDateTime soDate;

    @ApiModelProperty("下单渠道类型")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String soSource;
    private String soSourceName;

    @ApiModelProperty("是否赠品")
    private String giftsFlag;

    @ApiModelProperty("本次对账数量")
    private BigDecimal soaQty;

    @ApiModelProperty("折扣后主含税单价")
    private BigDecimal discountPrice;

    @ApiModelProperty("对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty("发票折扣率")
    private BigDecimal invDiscount;

    @ApiModelProperty("可开票税额")
    private BigDecimal invTaxAmt;

    @ApiModelProperty("可开票未税金额")
    private BigDecimal invNetAmt;

    @ApiModelProperty("原主含税单价")
    private BigDecimal mainPrice;

    @ApiModelProperty("单品折扣")
    private BigDecimal itemDiscount;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("明细行客户编码")
    private String dtlCustCode;

    @ApiModelProperty("明细行客户名称")
    private String dtlCustName;

    @ApiModelProperty("明细行客户id")
    private Long dtlCustId;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;

    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

}
