package com.elitesland.fin.application.service.writeoff;


import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;

import java.util.Collection;
import java.util.List;

/**
 * 核销申请明细拆分.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinApPayVerApplySettleService {

    /**
     * 批量插入.
     *
     * @param masId    主表ID
     * @param saveList 数据集合
     */
    void createBatch(Long masId, List<FinApPayVerApplySettleSaveDTO> saveList);

    /**
     * 数据查询.
     *
     * @param masIds 主表ID集合
     * @return 数据集合
     */
    List<FinApPayVerApplySettleVO> listByMasIds(Collection<Long> masIds);

    /**
     * 更新核销处理编号.
     *
     * @param masIds 主表ID集合
     * @param bachNo 核销处理编号
     */
    void updateBatchNo(Collection<Long> masIds, String bachNo);

	/**
	 * 更新核销处理核销类型
	 * @param masIds
	 * @param verFlag
	 */
	void updateVerFlag(Collection<Long> masIds, String verFlag);

	/**
	 * 更新核销批次号-应收
	 * @param arDid
	 * @param batchNo
	 *//*
	void updateBatchNoByArDid(String arDid, String batchNo);

	*//**
	 * 更新核销批次号-收款
	 * @param rcDid
	 * @param batchNo
	 *//*
	void updateBatchNoByRcDid(String rcDid, String batchNo);*/
}
