package com.elitesland.fin.provider.financial;


import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.financial.FinancialBillService;
import com.elitesland.fin.dto.financial.FinancialBillRpcDTO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.param.creditaccountflow.CreditAccountFlowRpcParam;
import com.elitesland.fin.repo.financial.FinancialBillRepo;
import com.elitesland.fin.service.creditaccountflow.CreditAccountFlowRpcService;
import com.elitesland.fin.service.financial.FinancialBillRpcService;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + FinancialBillRpcService.PATH)
@Slf4j
public class FinancialBillRpcServiceImpl implements FinancialBillRpcService {

    private final FinancialBillService financialBillService;

    private final FinancialBillRepo financialBillRepo;


    @Override
    public ApiResult<Object> saveFinancialBill(List<FinancialBillRpcDTO> param) {
        List<String> payOrder = param.stream().map(FinancialBillRpcDTO::getPayOrderId).collect(Collectors.toList());
        List<FinancialBillDO> financialBillDOList = financialBillRepo.findByPayOrderIdIn(payOrder);
        financialBillDOList.forEach(financialBillDO -> {
            if (financialBillDO.getPayOrderId() != null) {
                throw new RuntimeException("账单ID"+financialBillDO.getPayOrderId()+"已存在");
            }
        });
        List<FinancialBillSaveParam> financialBillSaveParams = FinancialBillConvert.INSTANCE.dtoToParam(param);
        financialBillService.batchSaveFinancialBill(financialBillSaveParams);
        return ApiResult.ok();
    }
}
