/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arverrec;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arverrec.ArVerRecDtlConvert;
import com.elitesland.fin.application.facade.param.arverrec.ArVerRecSaveParam;
import com.elitesland.fin.application.facade.vo.arverrec.ArVerRecDtlVO;
import com.elitesland.fin.application.service.arverrec.ArVerRecService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arverrec.ArVerRecDtl;
import com.elitesland.fin.domain.param.arverrec.ArVerRecPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.domain.service.arverrec.ArVerRecDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitesland.fin.infr.factory.arverrec.ArVerRecFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArVerRecServiceImpl
implements ArVerRecService {
    private final ArVerRecFactory arVerRecFactory;
    private final ArVerConfigDomainService arVerConfigDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final RecOrderDomainService recOrderDomainService;
    private final ArVerRecDomainService arVerRecDomainService;

    @Override
    @SysCodeProc
    public PagingVO<ArVerRecDtlVO> page(ArVerRecPageParam pageParam) {
        PagingVO<ArVerRecDtlDTO> page = this.arVerRecFactory.page(pageParam);
        return ArVerRecDtlConvert.INSTANCE.convertPage(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirm(ArVerRecSaveParam param) {
        ArVerConfigDTO arVerConfigDTO = this.arVerConfigDomainService.queryById(param.getConfigId());
        if (arVerConfigDTO == null || !arVerConfigDTO.getEnableFlag().booleanValue()) {
            throw new BusinessException("\u8be5\u65b9\u6848[\u5e94\u6536\u6838\u9500\u65b9\u6848ID" + param.getConfigId() + "]\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528");
        }
        List configDtlDTOList = arVerConfigDTO.getArVerConfigDtlDTOS().stream().filter(ArVerConfigDtlDTO::getMatchFlag).collect(Collectors.toList());
        Map<String, Class> conditions = configDtlDTOList.stream().collect(Collectors.toMap(ArVerConfigDtlDTO::getFieldNo, t -> {
            if (t.getFieldType().equals("String")) {
                return String.class;
            }
            if (t.getFieldType().equals("BigDecimal")) {
                return BigDecimal.class;
            }
            if (t.getFieldType().equals("LocalDateTime")) {
                return LocalDateTime.class;
            }
            if (t.getFieldType().equals("Long")) {
                return Long.class;
            }
            return String.class;
        }));
        param.getParams().forEach(s -> {
            s.setSchemeId(arVerConfigDTO.getId());
            s.setSchemeName(arVerConfigDTO.getSchemeName());
            s.setSchemeNo(arVerConfigDTO.getSchemeNo());
            s.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_MANU.getValueCode());
        });
        List<ArVerRecDtl> arVerRecDtls = ArVerRecDtlConvert.INSTANCE.convertList(param.getParams());
        Map<String, List<ArVerRecDtl>> listMap = arVerRecDtls.stream().collect(Collectors.groupingBy(t -> this.groupByCond(t, conditions)));
        for (Map.Entry<String, List<ArVerRecDtl>> entry : listMap.entrySet()) {
            this.arVerRecDomainService.save(entry.getValue());
        }
        arVerRecDtls.forEach(t -> {
            if (t.getOrderType().equals("AR")) {
                this.arOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
            } else if (t.getOrderType().equals("REC")) {
                this.recOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
            }
        });
    }

    @Override
    public void cancel(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            throw new BusinessException("\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<Long> masIds = new HashSet<Long>(ids);
        List<ArVerRecDtlDTO> recDtlDTOS = this.arVerRecDomainService.queryDtlByMasIds(masIds);
        if (CollUtil.isEmpty(recDtlDTOS)) {
            throw new BusinessException("\u5e94\u6536\u6838\u9500\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        List<Long> dtlIds = recDtlDTOS.stream().map(ArVerRecDtlDTO::getId).collect(Collectors.toList());
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long rows = this.arVerRecDomainService.logicDelByIds(masIds, user.getUsername(), user.getId());
        Long dtlRows = this.arVerRecDomainService.logicDelDtlByIds(dtlIds);
        if (rows.intValue() != masIds.size() || dtlRows.intValue() != dtlIds.size()) {
            throw new BusinessException("\u53d6\u6d88\u5e94\u6536\u6838\u9500\u5931\u8d25");
        }
        Map<Long, List<ArVerRecDtlDTO>> recDtlDTOMap = recDtlDTOS.stream().collect(Collectors.groupingBy(ArVerRecDtlDTO::getOrderId));
        for (Map.Entry<Long, List<ArVerRecDtlDTO>> entry : recDtlDTOMap.entrySet()) {
            String orderType = entry.getValue().get(0).getOrderType();
            BigDecimal amt = entry.getValue().stream().map(ArVerRecDtlDTO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            if (orderType.equals("AR")) {
                this.arOrderDomainService.updateVerAmt(entry.getKey(), amt);
                continue;
            }
            if (!orderType.equals("REC")) continue;
            this.recOrderDomainService.updateVerAmt(entry.getKey(), amt);
        }
    }

    private String groupByCond(Object object, Map<String, ?> conditions) {
        StringBuilder key = new StringBuilder();
        for (Map.Entry<String, ?> cond : conditions.entrySet()) {
            Object fieldValue = ReflectUtil.getFieldValue((Object)object, (String)cond.getKey());
            if (cond.getValue().equals(LocalDateTime.class)) {
                key.append(((LocalDateTime)fieldValue).toLocalDate().toString()).append("&");
                continue;
            }
            key.append(fieldValue.toString()).append("&");
        }
        return key.toString();
    }

    public ArVerRecServiceImpl(ArVerRecFactory arVerRecFactory, ArVerConfigDomainService arVerConfigDomainService, ArOrderDomainService arOrderDomainService, RecOrderDomainService recOrderDomainService, ArVerRecDomainService arVerRecDomainService) {
        this.arVerRecFactory = arVerRecFactory;
        this.arVerConfigDomainService = arVerConfigDomainService;
        this.arOrderDomainService = arOrderDomainService;
        this.recOrderDomainService = recOrderDomainService;
        this.arVerRecDomainService = arVerRecDomainService;
    }
}

