package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.limitadjustorder.LimitAdjustOrderVO;
import com.elitesland.fin.application.service.excel.entity.LimitAdjustExportEntity;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import static com.elitesland.fin.application.service.excel.ExportConstants.FIN_LIMIT_ADJUST_EXPORT;

@Service
@AllArgsConstructor
public class LimitAdjustExportUsingParamServiceImpl implements DataExport<LimitAdjustExportEntity, LimitAdjustOrderParam> {
    private final LimitAdjustOrderService limitAdjustOrderService;
    @Override
    public String getTmplCode() {
        return FIN_LIMIT_ADJUST_EXPORT;
    }
    @Override
    public PagingVO<LimitAdjustExportEntity> executeExport(LimitAdjustOrderParam queryParam) {
        PagingVO<LimitAdjustOrderVO> page = limitAdjustOrderService.page(queryParam);
        return new PagingVO<>(
            page.getTotal(), ExcelConvertUtils.convertLoosely(page.getRecords(), LimitAdjustExportEntity.class)
        );
    }
}
