package com.elitesland.fin.application.service.writeoff;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecApplyApprovalDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplySaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.vo.arorder.WriteoffVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplySettleVO;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyVO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;

import java.util.List;

/**
 * 核销申请.
 *
 * @author shihao.ma
 * @since 2023/9/6
 */
public interface FinArRecVerApplyService {

    /**
     * 保存核销申请单信息.
     *
     * @param save 单据信息
     * @return 主键
     */
    Long save(FinArRecVerApplySaveDTO save);

    /**
     * 提交核销申请单信息.
     *
     * @param save 单据信息
     * @return 主键
     */
    Long submit(FinArRecVerApplySaveDTO save);

    /**
     * 表头核销
     */
    Long writeOffSubmit(FinArRecVerApplySaveDTO save);

    /**
     * 获取应收收款核销申请单明细.
     *
     * @param id 主键
     * @return 查询结果
     */
    FinArRecVerApplyVO detail(Long id);

    FinArRecVerApplyVO writeOffDetail(Long id);

    /**
     * 分页查询.
     *
     * @param query 查询参数
     * @return 查询结果
     */
    PagingVO<FinArRecVerApplyVO> page(FinArRecVerApplyQuery query);

    PagingVO<FinArRecVerApplyVO> writeOffPage(FinArRecVerApplyQuery query);


    /**
     * 审批通过.
     *
     * @param dto 操作参数
     */
    void approve(FinArRecApplyApprovalDTO dto);

    void writeOffApprove(FinArRecApplyApprovalDTO dto);

	/**
	 * 核销接口重试
	 * @param param
	 * @return
	 */
/*	ApiResult<String> reTrySend2Nc(ReTryParam param);*/

    /**
     * 审批拒绝.
     *
     * @param dto 操作参数
     */
    void refuse(FinArRecApplyApprovalDTO dto);

    void writeOffRefuse(FinArRecApplyApprovalDTO dto);

    /**
     * 取消核销.
     *
     * @param id 主键
     */
	void cancel(Long id);

    void writeOffCancel(Long id);


    /**
     * 根据主键集合批量删除.
     *
     * @param ids 主键集合
     */
    void deleteByIds(List<Long> ids);

    /**
     * 获取明细拆单集合.
     *
     * @param id 申请单主键
     */
    List<FinArRecVerApplySettleVO> settleList(Long id);
    public Long autoWriteoff(List<WriteoffVO> writeoffVOS,Long schemeId);
    /**
     * 自动核销
     * @param arOrderDTO
     */
    public void autoWriteoffAr(ArOrderDTO arOrderDTO);

    public void autoWriteoffRec(RecOrderDTO recOrderDTO);
}
