/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeLineConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFastCodeVO;
import com.elitesland.fin.application.service.accountingengine.FinFastCodeService;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepoProc;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinFastCodeServiceImpl
implements FinFastCodeService {
    private static final Logger log = LoggerFactory.getLogger(FinFastCodeServiceImpl.class);
    private final FinFastCodeRepo finFastCodeRepo;
    private final FinFastCodeRepoProc finFastCodeRepoProc;
    private final FinFastCodeLineRepo finFastCodeLineRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinFastCodeVO> page(FinFastCodeParam finFastCodeParam) {
        return FinFastCodeConvert.INSTANCE.DTOToVO(this.finFastCodeRepoProc.page(finFastCodeParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinFastCodeParam finFastCodeParam) {
        this.checkEnableOrDisableParam(finFastCodeParam);
        List finFastCodeDOList = this.finFastCodeRepo.findAllById(finFastCodeParam.getIds());
        finFastCodeDOList.stream().forEach(item -> Assert.isFalse((boolean)finFastCodeParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finFastCodeDOList.stream().forEach(item -> item.setStatus(finFastCodeParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinFastCodeParam finFastCodeParam) {
        Assert.notEmpty(finFastCodeParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFastCodeParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinFastCodeParam finFastCodeParam) {
        this.checkSaveOrUpdateParam(finFastCodeParam);
        this.checkIdempotent(finFastCodeParam);
        FinFastCodeDO finFastCodeDO = (FinFastCodeDO)this.finFastCodeRepo.save(FinFastCodeConvert.INSTANCE.paramToDO(finFastCodeParam));
        this.finFastCodeLineRepo.deleteAllByMasId(finFastCodeDO.getId());
        List<FinFastCodeLineParam> finFastCodeLineParamList = finFastCodeParam.getFinFastCodeLineDetailList();
        finFastCodeLineParamList.stream().forEach(item -> item.setMasId(finFastCodeDO.getId()));
        this.finFastCodeLineRepo.saveAll(FinFastCodeLineConvert.INSTANCE.paramToDO(finFastCodeLineParamList));
        return finFastCodeDO.getId();
    }

    private void checkSaveOrUpdateParam(FinFastCodeParam finFastCodeParam) {
        Assert.notEmpty((CharSequence)finFastCodeParam.getFastCode(), (String)"\u5feb\u7801\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFastCodeParam.getFastName(), (String)"\u5feb\u7801\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFastCodeParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        List<FinFastCodeLineParam> finFastCodeLineParamList = finFastCodeParam.getFinFastCodeLineDetailList();
        Assert.notEmpty(finFastCodeLineParamList, (String)"\u5feb\u7801\u660e\u7ec6\u5fc5\u586b", (Object[])new Object[0]);
    }

    private void checkIdempotent(FinFastCodeParam finFastCodeParam) {
        FinFastCodeDO finFastCodeDO = this.finFastCodeRepoProc.findByFastCode(finFastCodeParam.getFastCode());
        if (finFastCodeDO != null) {
            Assert.equals((Object)finFastCodeParam.getId(), (Object)finFastCodeDO.getId(), (String)"\u5feb\u7801\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
        List<FinFastCodeLineParam> finFastCodeLineParamList = finFastCodeParam.getFinFastCodeLineDetailList();
        HashSet uniqueFields = new HashSet();
        finFastCodeLineParamList.stream().forEach(item -> {
            String uniqueField = this.buildUniqueField((FinFastCodeLineParam)((Object)item));
            Assert.isFalse((boolean)uniqueFields.contains(uniqueField), (String)"\u6761\u4ef6123\u5b57\u6bb5\u6761\u4ef6123\u5b57\u6bb5\u503c\u91cd\u590d", (Object[])new Object[0]);
            uniqueFields.add(uniqueField);
        });
    }

    private String buildUniqueField(FinFastCodeLineParam finFastCodeLineParam) {
        return finFastCodeLineParam.getConditionOne() + finFastCodeLineParam.getConditionOneValue() + finFastCodeLineParam.getConditionTwo() + finFastCodeLineParam.getConditionTwoValue() + finFastCodeLineParam.getConditionThree() + finFastCodeLineParam.getConditionThreeValue();
    }

    public FinFastCodeServiceImpl(FinFastCodeRepo finFastCodeRepo, FinFastCodeRepoProc finFastCodeRepoProc, FinFastCodeLineRepo finFastCodeLineRepo) {
        this.finFastCodeRepo = finFastCodeRepo;
        this.finFastCodeRepoProc = finFastCodeRepoProc;
        this.finFastCodeLineRepo = finFastCodeLineRepo;
    }
}

