/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.unionpay.impl;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitesland.fin.application.service.unionpay.OfflinePayService;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.entity.account.AccountStorageDO;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepoProc;
import com.elitesland.fin.repo.account.AccountStorageDetailRepo;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfflinePayServiceImpl
implements OfflinePayService {
    private static final Logger log = LoggerFactory.getLogger(OfflinePayServiceImpl.class);
    @Autowired
    private AccountStorageRepo accountStorageRepo;
    @Autowired
    private AccountStorageRepoProc accountStorageRepoProc;
    @Autowired
    private RecOrderRpcFiledRepo recOrderRpcFiledRepo;
    @Autowired
    private AccountStorageDetailRepo accountStorageDetailRepo;
    private final AccountFlowRpcService accountFlowRpcService;
    private final RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc;
    private final RecOrderDtlRepo recOrderDtlRepo;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;

    @Override
    @Transactional
    public Long offlinePay(SendPayReq payReq) {
        this.checkOfflinePayParam(payReq);
        String receiptStatus = this.accountStorageRepo.getReceiptStatusByOrderId(payReq.getPayOrderId());
        if (!ReceiptStatusEnum.PENDING_PAY.getCode().equals(receiptStatus)) {
            log.error("\u5f53\u524d\u50a8\u503c\u5355\u5355\u636e\u72b6\u6001\u975e\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u652f\u4ed8\uff0c\u5355\u636e\u6d41\u6c34\u53f7\u4e3a:[{}]", (Object)payReq.getPayOrderId());
            throw new BusinessException("\u5f53\u524d\u50a8\u503c\u5355\u5355\u636e\u72b6\u6001\u975e\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u65e0\u6cd5\u91cd\u590d\u53d1\u8d77\u652f\u4ed8\uff0c\u5355\u636e\u6d41\u6c34\u53f7\u4e3a:" + payReq.getPayOrderId());
        }
        AccountStorageDO storageDO = new AccountStorageDO();
        storageDO.setId(payReq.getStorageId());
        storageDO.setReceiptStatus(payReq.getReceiptStatus());
        this.accountStorageRepoProc.updateAccountStorage(payReq);
        this.recOrderRpcFiledRepoProc.updateRecOrderDtl(payReq);
        this.recOrderRpcFiledRepo.updateReceiptStatus(payReq.getPayOrderId(), payReq.getReceiptStatus());
        this.recOrderRpcFiledRepoProc.updateRecOrderExtend(payReq);
        RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
        recOrderRpcTwoParam.setSourceNo(payReq.getPayOrderId());
        List<RecOrderRpcPageRespVo> recOrderRpcPageRespVoList = this.recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
        Assert.notEmpty(recOrderRpcPageRespVoList, (String)"\u67e5\u8be2\u4e0d\u5230\u6536\u6b3e\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Assert.isTrue((recOrderRpcPageRespVoList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u6536\u6b3e\u5355\u4fe1\u606f", (Object[])new Object[0]);
        RecOrderRpcPageRespVo recOrderRpcPageRespVo = recOrderRpcPageRespVoList.get(0);
        Long id = recOrderRpcPageRespVo.getId();
        this.recOrderDtlRepoProc.updateByMasId(payReq, id);
        return recOrderRpcPageRespVoList.get(0).getId();
    }

    private void checkOfflinePayParam(SendPayReq sendPayReq) {
        Assert.notEmpty((CharSequence)sendPayReq.getRecType(), (String)"\u6536\u6b3e\u65b9\u5f0f\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getRemitterAccount(), (String)"\u6c47\u6b3e\u8d26\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getRemitterBankName(), (String)"\u6c47\u6b3e\u94f6\u884c\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getReceiptStatus(), (String)"\u5355\u636e\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getPayOrderId(), (String)"\u652f\u4ed8\u6d41\u6c34\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getRecBank(), (String)"\u6536\u6b3e\u94f6\u884c\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getRecAcc(), (String)"\u6536\u6b3e\u8d26\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)sendPayReq.getApplyFile(), (String)"\u652f\u4ed8\u51ed\u8bc1\u5fc5\u586b", (Object[])new Object[0]);
    }

    public OfflinePayServiceImpl(AccountFlowRpcService accountFlowRpcService, RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc, RecOrderDtlRepo recOrderDtlRepo, RecOrderDtlRepoProc recOrderDtlRepoProc) {
        this.accountFlowRpcService = accountFlowRpcService;
        this.recOrderRpcFiledRepoProc = recOrderRpcFiledRepoProc;
        this.recOrderDtlRepo = recOrderDtlRepo;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
    }
}

