package com.elitesland.fin.application.service.expense;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.expense.ExpRuleConfigDTO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSaveParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSortParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;

import java.util.List;

/**
 * @author Mark
 * @Date: 2024/8/13 13:23
 */
public interface ExpenseRuleConfigService {
    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param);

    /**
     * 保存/更新
     *
     * @param param
     */
    void saveOrUpdate(ExpRuleConfigSaveParam param);

    void sort(List<ExpRuleConfigSortParam> param);

    /**
     * 删除主+明细信息
     *
     * @param id
     */
    void del(Long id);

    /**
     * 详情信息
     *
     * @param id
     * @return
     */
    ExpRuleConfigQueryVO detail(Long id);

    List<ExpRuleConfigQueryVO> getList(String code);

    List<ExpRuleConfigQueryVO> getListByParam(ExpRuleConfigQueryParam param);


    List<ExpRuleConfigQueryVO> getExpTypeList();

    void updateEnableFlag(List<Long> ids, boolean enable);

    /**
     * 根据场景码获取账户规则操作配置，优先缓存
     *
     * @param ruleCode
     * @return
     */
    ExpRuleConfigDTO getByRuleCode(String ruleCode);

    /**
     * 查询账户规则，但是不翻译名称
     *
     * @param param
     * @return
     */
    PagingVO<ExpRuleConfigPageVO> searchPageWithOutName(ExpRuleConfigQueryParam param);
}
