package com.elitesland.fin.domain.entity.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/4/13 16:59
 */
@Data
public class RecOrder {

    private String custType2;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;

    private Long id;

    private String sourceNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private Long arTypeId;

    private String arTypeName;

    private String arTypeCode;

    private Long recTypeId;

    private String recTypeCode;

    private String recTypeName;

    private String recOrderNo;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private String orderState;

    private BigDecimal exchangeRate;

    private Boolean initFlag;

    private BigDecimal realRecAmt;

    private BigDecimal realRecCurAmt;

    private LocalDateTime reDate;

    private Boolean reFlag;

    private String auditRejection;

    private String createMode;

    private String verState;

    private BigDecimal verAmt;

    private Long custId;

    private String custCode;

    private String custName;

    private Long buId;

    private String buCode;

    private String buName;

    private String recOuCode;

    private Long recOuId;

    private String recOuName;

    private String orgCode;

    private Long orgId;

    private String orgName;

    private BigDecimal taxAmt;

    private String recOrderType;

    private Long saleUserId;

    private String saleUser;

    private String creator;

    private BigDecimal taxCurAmt;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<RecOrderDtl> dtlList;

    private String addrNo;

    private String suppAddrNo;

    private String docType;

    private String docType2;

    private String docCls;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @ApiModelProperty("拟定状态,DRAFT：草稿，PROPOSING：拟定中，PROPOSED_FAIL：拟定失败，PROPOSED_SUCCESS：拟定成功，SENDING：传输中，SEND_FAIL：传输失败，SEND_SUCCESS：传输成功")
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    private String proposedStatus;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;

//    @ApiModelProperty("发票号")
//    private String es1;
//
//    @ApiModelProperty("红冲标志")
//    private String es2;
//
//    @ApiModelProperty("开票备注")
//    private String es3;
//
//    @ApiModelProperty("第三方支付辅助")
//    private String es4;
//
//    @ApiModelProperty("消费卡辅助")
//    private String es5;
//
//    @ApiModelProperty("信用卡辅助")
//    private String es6;
//
//    @ApiModelProperty("结算方式")
//    private String es7;
//
//    @ApiModelProperty("收款银行账户")
//    private String es8;
//
//    @ApiModelProperty("付款银行账户")
//    private String es9;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @ApiModelProperty("是否检验")
    private Boolean check = Boolean.TRUE;

    private String remark;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;


    public void checkOrderState() {
        if (!check){
            return;
        }
        if (!this.orderState.equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "只能编辑收款单为草稿状态的单据!");
        }
    }

    public void defaultVer() {
        this.verAmt = BigDecimal.ZERO;
        this.verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
    }

    public void checkTotalMoney() {
        if (!check){
            return;
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "总金额不能为0!");
        }
        if (totalCurAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "总金额(本位币)不能为0!");
        }
        if (CollUtil.isEmpty(this.dtlList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行数据不能为空!");
        }
    }

    public void checkDtl(Boolean flag) {
        if (!check){
            return;
        }
        dtlList.forEach(dtl -> {
            //非空校验
            dtl.checkNotNull(false, createMode);
            if (flag) {
                //金额校验
                dtl.checkMoney(this.exchangeRate);
            }
        });
    }

    public void checkMoney() {
        if (!check){
            return;
        }

        //1.总金额：取值收款信息行-汇总行SUM（总金额）；
        BigDecimal totalAmountDtl = this.dtlList.stream()
                .map(RecOrderDtl::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        //2.总金额本位币：取值收款明细-汇总行SUM（总金额本位币）；
        BigDecimal totalCarAmountDtl = this.dtlList.stream()
                .map(RecOrderDtl::getTotalCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        //3.实际收款金额：取值收款明细-汇总行SUM（实际收款金额）；
        BigDecimal realPayAmtDtl = this.dtlList.stream()
                .map(RecOrderDtl::getRealRecAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        //4.实际收款金额本位币：取值收款明细-汇总行SUM（实际收款金额本位币）；
        BigDecimal realPayCurAmtDtl = this.dtlList.stream()
                .map(RecOrderDtl::getRealRecCurAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);


        if (this.totalAmt.compareTo(totalAmountDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额之和与总单总金额不等!");
        }
        //2.总金额本位币：取值付款信息行-汇总行SUM（总金额本位币）；
        if (this.totalCurAmt.compareTo(totalCarAmountDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额(本位币)之和与总单金额(本位币)不等!");
        }
        //3.实际支付金额：取值付款信息行-汇总行SUM（实际支付金额）；
        if (this.realRecAmt.compareTo(realPayAmtDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际收款金额之和与总单实际收款金额不等!");
        }
        //4.实际支付金额本位币：取值付款信息行-汇总行SUM（实际支付金额本位币）；
        if (this.realRecCurAmt.compareTo(realPayCurAmtDtl) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际收款金额(本位币)之和与总单实际收款金额(本位币)不等!");
        }

    }

    //必填项非空校验
    public void checkNotNull(String createMode) {
        if (!check){
            return;
        }
//        Assert.notNull(this.ouId, "销售公司ID不能为空");
//        Assert.notNull(this.ouName, "销售公司名称不能为空");
        Assert.notNull(this.ouCode, "销售公司编码不能为空");
//        Assert.notNull(this.recOuId, "收款公司ID不能为空");
//        Assert.notNull(this.recOuName, "收款公司名称不能为空");
        Assert.notNull(this.recOuCode, "收款公司编码不能为空");
        Assert.notNull(this.reDate, "收款日期不能为空");
        Assert.notNull(this.currCode, "币种编码不能为空");
//        Assert.notNull(this.currName, "币种名称不能为空");
        Assert.notNull(this.exchangeRate, "汇率不能为空");
        // 来源手工
        if (createMode.equals(UdcEnum.FIN_REC_DOC_CLS_MANU.getValueCode())) {
            Assert.notNull(this.recTypeId, "收款单类型定义ID不能为空");
            Assert.notNull(this.recTypeCode, "收款单类型定义编码不能为空");
            Assert.notNull(this.recTypeName, "收款单类型定义名称不能为空");
            Assert.notNull(this.custId, "客户ID不能为空");
            Assert.notNull(this.custCode, "客户编码不能为空");
            Assert.notNull(this.custName, "客户名称不能为空");
        }
        // 销售订单
        if (createMode.equals(UdcEnum.FIN_REC_DOC_CLS_SO.getValueCode())) {
            Assert.notNull(this.taxAmt, "税额 taxAmt不能为空");
            Assert.notNull(this.orgId, "销售组织 orgId不能为空");
            Assert.notNull(this.orgCode, "销售组织 orgCode不能为空");
            Assert.notNull(this.orgName, "销售组织 orgName不能为空");
            Assert.notNull(this.reFlag, "是否预收 reFlag不能为空");
            Assert.notNull(this.localCurrCode, "本位币 code不能为空");
            Assert.notNull(this.localCurrName, "本位币 name不能为空");
            Assert.notNull(this.custName, "客户名称不能为空");
            Assert.notEmpty(this.docType2, "docType2 is null");
            Assert.notEmpty(this.docType, "docType is null");
            Assert.notEmpty(this.docCls, "docCls is null");
            if (this.docType2.equals("B")) {
                Assert.notNull(this.custId, "客户 custId is null");
                Assert.notEmpty(this.custCode, "客户 custCode is null");
            }
        }

    }

    /**
     * 计算销售来源的数据
     */
    public void countBySo() {
        if (!check){
            return;
        }
        // 计算明细数据
        for (RecOrderDtl recOrderDtl : this.dtlList) {
            // //总金额(本位币)=总金额*汇率；
//            BigDecimal totalCurAmtIn = recOrderDtl.getTotalAmt().multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            BigDecimal totalCurAmtIn = NumberUtil.mul(recOrderDtl.getTotalAmt(), exchangeRate).setScale(2, RoundingMode.HALF_UP);

            recOrderDtl.setTotalCurAmt(totalCurAmtIn);
            // 实际收款金额(本位币)=实际收款金额*汇率；
//            BigDecimal realRecCurAmtIn = recOrderDtl.getRealRecAmt().multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            BigDecimal realRecCurAmtIn = NumberUtil.mul(recOrderDtl.getRealRecAmt(), exchangeRate).setScale(2, RoundingMode.HALF_UP);
            recOrderDtl.setRealRecCurAmt(realRecCurAmtIn);
        }
        // 计算单头数据
        //1.总金额：取值收款信息行-汇总行SUM（总金额）；
        BigDecimal totalAmountDtl = this.dtlList.stream().filter(item-> ObjectUtil.isNotNull(item.getTotalAmt()))
                .map(RecOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.totalAmt = totalAmountDtl;
        //2.总金额本位币：取值收款明细-汇总行SUM（总金额本位币）；
        BigDecimal totalCarAmountDtl = this.dtlList.stream().filter(item-> ObjectUtil.isNotNull(item.getTotalCurAmt()))
                .map(RecOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.totalCurAmt = totalCarAmountDtl;
        //3.实际收款金额：取值收款明细-汇总行SUM（实际收款金额）；
        BigDecimal realPayAmtDtl = this.dtlList.stream().filter(item-> ObjectUtil.isNotNull(item.getRealRecAmt()))
                .map(RecOrderDtl::getRealRecAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.realRecAmt = realPayAmtDtl;
        //4.实际收款金额本位币：取值收款明细-汇总行SUM（实际收款金额本位币）；
        BigDecimal realPayCurAmtDtl = this.dtlList.stream().filter(item-> ObjectUtil.isNotNull(item.getRealRecCurAmt()))
                .map(RecOrderDtl::getRealRecCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.realRecCurAmt = realPayCurAmtDtl;

    }

    public void setSoDef() {
        this.initFlag = false;
    }
}
