package com.elitesland.fin.repo.accountingengine;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinJournalLogDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalLogParam;
import com.elitesland.fin.domain.entity.accountingengine.QFinJournalDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinJournalLogDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinJournalLogRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QFinJournalLogDO qFinJournalLogDO = QFinJournalLogDO.finJournalLogDO;

    public PagingVO<FinJournalLogDTO> page(FinJournalLogParam finJournalLogParam) {
        Predicate where = where(finJournalLogParam);
        JPAQuery<FinJournalLogDTO> query = select(FinJournalLogDTO.class).where(ExpressionUtils.allOf(where));
        finJournalLogParam.setPaging(query);
        finJournalLogParam.fillOrders(query, qFinJournalLogDO);

        List<FinJournalLogDTO> finFlexibleDTOList = query.fetch();

        return PagingVO.<FinJournalLogDTO>builder()
                .total(query.fetchCount())
                .records(finFlexibleDTOList)
                .build();
    }

    private Predicate where(FinJournalLogParam finJournalLogParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finJournalLogParam.getId() != null, qFinJournalLogDO.id, finJournalLogParam.getId())
                .andLike(StringUtils.isNotEmpty(finJournalLogParam.getDocNum()), qFinJournalLogDO.docNum, StringUtil.buildLikeString(finJournalLogParam.getDocNum()))
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinJournalLogDO.id,
                qFinJournalLogDO.docNum,
                qFinJournalLogDO.log,

                qFinJournalLogDO.createTime,
                qFinJournalLogDO.creator,
                qFinJournalLogDO.modifyTime,
                qFinJournalLogDO.updater
        )).from(qFinJournalLogDO);
    }
}
