/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleVO;
import com.elitesland.fin.application.service.accountingengine.FinFlexibleService;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinFlexibleServiceImpl
implements FinFlexibleService {
    private static final Logger log = LoggerFactory.getLogger(FinFlexibleServiceImpl.class);
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleRepoProc finFlexibleRepoProc;
    private final FinFlexibleValueRepo finFlexibleValueRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinFlexibleVO> page(FinFlexibleParam finFlexibleParam) {
        return FinFlexibleConvert.INSTANCE.DTOToVO(this.finFlexibleRepoProc.page(finFlexibleParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinFlexibleParam finFlexibleParam) {
        this.checkEnableOrDisableParam(finFlexibleParam);
        List finFlexibleDOList = this.finFlexibleRepo.findAllById(finFlexibleParam.getIds());
        finFlexibleDOList.stream().forEach(item -> Assert.isFalse((boolean)finFlexibleParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finFlexibleDOList.stream().forEach(item -> item.setStatus(finFlexibleParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinFlexibleParam finFlexibleParam) {
        Assert.notEmpty(finFlexibleParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFlexibleParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinFlexibleParam finFlexibleParam) {
        this.checkSaveOrUpdateParam(finFlexibleParam);
        this.checkIdempotent(finFlexibleParam);
        FinFlexibleDO finFlexibleDO = (FinFlexibleDO)this.finFlexibleRepo.save(FinFlexibleConvert.INSTANCE.paramToDO(finFlexibleParam));
        this.finFlexibleValueRepo.deleteAllByMasId(finFlexibleDO.getId());
        List<FinFlexibleValueParam> finFlexibleValueParamList = finFlexibleParam.getDetailList();
        finFlexibleValueParamList.stream().forEach(item -> item.setMasId(finFlexibleDO.getId()));
        this.finFlexibleValueRepo.saveAll(FinFlexibleValueConvert.INSTANCE.paramToDO(finFlexibleValueParamList));
        return finFlexibleDO.getId();
    }

    private void checkSaveOrUpdateParam(FinFlexibleParam finFlexibleParam) {
        Assert.notEmpty((CharSequence)finFlexibleParam.getFlexibleCode(), (String)"\u503c\u96c6\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFlexibleParam.getFlexibleName(), (String)"\u503c\u96c6\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFlexibleParam.getFlexibleType(), (String)"\u503c\u96c6\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finFlexibleParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        List<FinFlexibleValueParam> finFlexibleValueParamList = finFlexibleParam.getDetailList();
        if (CollectionUtils.isNotEmpty(finFlexibleValueParamList)) {
            finFlexibleValueParamList.stream().forEach(item -> {
                Assert.notNull((Object)item.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getFlexibleValueCode(), (String)"\u503c\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getFlexibleValueName(), (String)"\u503c\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notNull((Object)item.getDescendantsFlag(), (String)"\u662f\u5426\u6709\u5b50\u4ee3\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notNull((Object)item.getActiveFlag(), (String)"\u662f\u5426\u542f\u7528\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notNull((Object)item.getAccountFlag(), (String)"\u662f\u5426\u8bb0\u8d26\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notNull((Object)item.getActiveStartTime(), (String)"\u8d77\u59cb\u6709\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notNull((Object)item.getActiveEndTime(), (String)"\u7ec8\u6b62\u6709\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
                if (StringUtils.isNotEmpty((String)finFlexibleParam.getParentFlexibleCode())) {
                    Assert.notEmpty((CharSequence)item.getMasFlexibleValueCode(), (String)"\u4e3b\u503c\u5fc5\u586b", (Object[])new Object[0]);
                    Assert.notEmpty((CharSequence)item.getMasFlexibleValueName(), (String)"\u4e3b\u503c\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
                }
            });
        }
    }

    private void checkIdempotent(FinFlexibleParam finFlexibleParam) {
        FinFlexibleDO finFlexibleDO = this.finFlexibleRepoProc.findByFlexibleCode(finFlexibleParam.getFlexibleCode());
        if (finFlexibleDO != null) {
            Assert.equals((Object)finFlexibleParam.getId(), (Object)finFlexibleDO.getId(), (String)"\u503c\u96c6\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    public FinFlexibleServiceImpl(FinFlexibleRepo finFlexibleRepo, FinFlexibleRepoProc finFlexibleRepoProc, FinFlexibleValueRepo finFlexibleValueRepo) {
        this.finFlexibleRepo = finFlexibleRepo;
        this.finFlexibleRepoProc = finFlexibleRepoProc;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
    }
}

