/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.fin.application.convert.adjustorder.AdjustOrderConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.excel.adjust.AdjustOrderImportEntity;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderSaveParam;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderServiceImpl;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdjustOrderImportServiceImpl
implements DataImport<AdjustOrderImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(AdjustOrderImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final AccountRepoProc accountRepoProc;
    private final AdjustOrderRepo adjustOrderRepo;
    private final UdcProvider udcProvider;
    private final SysNumberGenerator sysNumberGenerator;
    private final AdjustOrderServiceImpl adjustOrderService;
    private final FlexFieldUtilService flexFieldUtilService;

    public String getTmplCode() {
        return "yst_fin_adjust_order_import";
    }

    public List<String> executeImport(List<AdjustOrderImportEntity> dataList, int rowId) {
        if (CollectionUtil.isEmpty(dataList)) {
            return List.of();
        }
        Set<String> accountCodeList = dataList.stream().map(AdjustOrderImportEntity::getAccCode).filter(code -> StrUtil.isNotBlank((CharSequence)code)).collect(Collectors.toSet());
        HashMap<String, AccountDTO> accountMap = new HashMap();
        if (CollectionUtil.isNotEmpty(accountCodeList)) {
            AccountParam accountParam = new AccountParam();
            accountParam.setAccountCodes(accountCodeList);
            List<AccountDTO> accountDTOList = this.accountRepoProc.getAccountByAccountParam(accountParam);
            accountMap = accountDTOList.stream().collect(Collectors.toMap(AccountDTO::getAccountCode, t -> t, (t1, t2) -> t1));
        }
        Map udcCodeMap = this.udcProvider.getValueMapByUdcCode(UdcEnum.ADJUST_TYPE_1.getModel(), Set.of(UdcEnum.ADJUST_TYPE_1.getCode(), UdcEnum.FIN_ADJUST_REASON_1.getCode()));
        Map<String, String> adjustTypeMap = ((Map)udcCodeMap.get(UdcEnum.ADJUST_TYPE_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        Map<String, String> adjustReasonMap = ((Map)udcCodeMap.get(UdcEnum.FIN_ADJUST_REASON_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        ArrayList<String> errorResult = new ArrayList<String>();
        ArrayList<AdjustOrderSaveParam> saveList = new ArrayList<AdjustOrderSaveParam>();
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (AdjustOrderImportEntity entity : dataList) {
            if (!StrUtil.isNotBlank((CharSequence)entity.getAccCode()) || !NumberUtil.isNumber((CharSequence)entity.getTotalAmt()) || !StrUtil.equals((CharSequence)entity.getAdjTypeName(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCodeName())) continue;
            totalAmt = NumberUtil.add((Number)totalAmt, (Number)new BigDecimal(entity.getTotalAmt()));
            amtMap.put(entity.getAccCode(), totalAmt);
        }
        for (AdjustOrderImportEntity importEntity : dataList) {
            AdjustOrderSaveParam adjustOrderSaveParam = new AdjustOrderSaveParam();
            ArrayList<String> errorList = new ArrayList<String>();
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
            this.checkImportMandatoryField(importEntity, errorList, rowId);
            this.checkUdc(rowId, importEntity, adjustOrderSaveParam, errorList, adjustTypeMap, adjustReasonMap);
            this.checkAccount(rowId, importEntity, adjustOrderSaveParam, errorList, accountMap, amtMap);
            adjustOrderSaveParam.setRemark(importEntity.getRemark());
            adjustOrderSaveParam.setType(UdcEnum.ADJUST_ORDER_TYPE_YETZ.getValueCode());
            adjustOrderSaveParam.setDocNo(docNo);
            adjustOrderSaveParam.setState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            adjustOrderSaveParam.setExtensionInfo(importEntity.getExtensionInfo());
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            } else {
                errorResult.add(null);
                saveList.add(adjustOrderSaveParam);
            }
            ++rowId;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.saveData(saveList);
            return CollectionUtil.isNotEmpty(errorResult) ? errorResult : null;
        }
        return errorResult;
    }

    private void checkUdc(int rowId, AdjustOrderImportEntity importEntity, AdjustOrderSaveParam adjustOrderSaveParam, List<String> errorList, Map<String, String> adjustTypeMap, Map<String, String> adjustReasonMap) {
        if (adjustReasonMap.containsKey(importEntity.getAdjReasonName())) {
            adjustOrderSaveParam.setAdjReason(adjustReasonMap.get(importEntity.getAdjReasonName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u539f\u56e0", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
        if (adjustTypeMap.containsKey(importEntity.getAdjTypeName())) {
            adjustOrderSaveParam.setAdjType(adjustTypeMap.get(importEntity.getAdjTypeName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u7c7b\u578b", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
    }

    private void checkAccount(int rowId, AdjustOrderImportEntity importEntity, AdjustOrderSaveParam adjustOrderSaveParam, List<String> errorList, Map<String, AccountDTO> accountMap, Map<String, BigDecimal> amtMap) {
        BigDecimal amt = BigDecimal.ZERO;
        if (NumberUtil.isNumber((CharSequence)importEntity.getTotalAmt())) {
            Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
            if (!pattern.matcher(importEntity.getTotalAmt()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\uff0c\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
            }
            if (NumberUtil.isLess((BigDecimal)(amt = new BigDecimal(importEntity.getTotalAmt())), (BigDecimal)BigDecimal.ZERO)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\uff0c\u4e0d\u80fd\u5c0f\u4e8e0"));
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\u683c\u5f0f\u4e0d\u5bf9"));
        }
        if (accountMap.containsKey(importEntity.getAccCode())) {
            AccountDTO accountDTO = accountMap.get(importEntity.getAccCode());
            if (!StrUtil.equals((CharSequence)accountDTO.getState(), (CharSequence)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u672a\u6fc0\u6d3b"));
            }
            if (StrUtil.equals((CharSequence)adjustOrderSaveParam.getAdjType(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCode()) && amtMap.containsKey(importEntity.getAccCode()) && NumberUtil.isGreater((BigDecimal)amtMap.get(importEntity.getAccCode()), (BigDecimal)accountDTO.getAccountAvailableAmount())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u51fa\u91d1\u989d\u5927\u4e8e\u8d26\u6237\u53ef\u7528\u91d1\u989d"));
            }
            adjustOrderSaveParam.setAccCode(importEntity.getAccCode());
            adjustOrderSaveParam.setAccName(accountDTO.getAccountName());
            adjustOrderSaveParam.setTotalAmt(amt);
            adjustOrderSaveParam.setAccType(accountDTO.getAccountType());
            adjustOrderSaveParam.setAccountHolderName(accountDTO.getAccountHolderName());
            adjustOrderSaveParam.setAccountHolderCode(accountDTO.getAccountHolderCode());
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u4e0d\u5b58\u5728"));
        }
    }

    private void checkImportMandatoryField(AdjustOrderImportEntity importEntity, List<String> errorList, int rowId) {
        if (StringUtils.isBlank((CharSequence)importEntity.getAccCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjTypeName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u7c7b\u578b", "\u8c03\u6574\u7c7b\u578b\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getTotalAmt())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjReasonName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u539f\u56e0", "\u8c03\u6574\u539f\u56e0\u5fc5\u586b"));
        }
    }

    public void saveData(List<AdjustOrderSaveParam> saveList) {
        List<AdjustOrderDO> doList = AdjustOrderConvert.INSTANCE.paramsToDOs(saveList);
        this.flexFieldUtilService.handFlexFieldValueFeferenceList("ADJUST_ORDER", doList);
        List adjustOrderDOS = this.adjustOrderRepo.saveAll(doList);
        this.submit(adjustOrderDOS);
    }

    public void submit(List<AdjustOrderDO> doList) {
        doList.stream().forEach(adjustOrderDO -> this.adjustOrderService.workflowAndGenerateAccountFlow((AdjustOrderDO)((Object)adjustOrderDO)));
    }

    public AdjustOrderImportServiceImpl(AccountRepoProc accountRepoProc, AdjustOrderRepo adjustOrderRepo, UdcProvider udcProvider, SysNumberGenerator sysNumberGenerator, AdjustOrderServiceImpl adjustOrderService, FlexFieldUtilService flexFieldUtilService) {
        this.accountRepoProc = accountRepoProc;
        this.adjustOrderRepo = adjustOrderRepo;
        this.udcProvider = udcProvider;
        this.sysNumberGenerator = sysNumberGenerator;
        this.adjustOrderService = adjustOrderService;
        this.flexFieldUtilService = flexFieldUtilService;
    }
}

