/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.financial;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.service.financial.FinancialBillService;
import com.elitesland.fin.dto.financial.FinancialBillRpcDTO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.repo.financial.FinancialBillRepo;
import com.elitesland.fin.service.financial.FinancialBillRpcService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/financialBill"})
public class FinancialBillRpcServiceImpl
implements FinancialBillRpcService {
    private static final Logger log = LoggerFactory.getLogger(FinancialBillRpcServiceImpl.class);
    private final FinancialBillService financialBillService;
    private final FinancialBillRepo financialBillRepo;

    public ApiResult<Object> saveFinancialBill(List<FinancialBillRpcDTO> param) {
        List<String> payOrder = param.stream().map(FinancialBillRpcDTO::getMsyDataId).collect(Collectors.toList());
        List<FinancialBillDO> financialBillDOList = this.financialBillRepo.findByMsyDataIdIn(payOrder);
        financialBillDOList.forEach(financialBillDO -> {
            if (financialBillDO.getMsyDataId() != null) {
                throw new RuntimeException("\u6570\u636eID" + financialBillDO.getMsyDataId() + "\u5df2\u5b58\u5728");
            }
        });
        List<FinancialBillSaveParam> financialBillSaveParams = FinancialBillConvert.INSTANCE.dtoToParam(param);
        this.financialBillService.batchSaveFinancialBill(financialBillSaveParams);
        return ApiResult.ok();
    }

    public FinancialBillRpcServiceImpl(FinancialBillService financialBillService, FinancialBillRepo financialBillRepo) {
        this.financialBillService = financialBillService;
        this.financialBillRepo = financialBillRepo;
    }
}

