package com.elitesland.fin.application.facade.vo.invoice;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "付款记录明细返回参数")
public class PaymentRecordsDRespVO implements Serializable {

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty(name = "商品编码名称")
    private String itemCodeName;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("明细表ID")
    private Long id;

    @ApiModelProperty("付款记录表头ID")
    private Long masId;

    @ApiModelProperty("明细行号")
    private Integer lineNo;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("税收分类编码")
    private String taxType;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String serviceName;

    @ApiModelProperty("规格")
    private String itemSpec;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal originAmt;

    @ApiModelProperty("税额")
    private BigDecimal tax;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

}
