package com.elitesland.fin.application.facade.vo.saleinv;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.saleinv
 * @date 2022/5/7 11:28
 */
@Data
public class SaleInvDtlVO implements Serializable {

    private static final long serialVersionUID = -5325621413411333532L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("应税货物或劳务、服务名称")
    private String taxName;

    @ApiModelProperty("税收分类编码")
    @SysCode(sys = "yst-supp", mod = "TAX_CLASS_CODE",nameField = "taxName")
    private String taxCode;
    private String taxCodeName;

    @ApiModelProperty("发票行性质")
    @SysCode(sys = "yst-fin", mod = "INV_NATURE")
    private String invNature;
    private String invNatureName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("规格型号")
    private String itemType;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位名称")
    private String uomName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("红/蓝票")
    private String invKind;

    @ApiModelProperty("查验状态")
    private String examType;

    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    private BigDecimal invAmt;

    @ApiModelProperty("发/收货单号")
    private String docNo;

    @ApiModelProperty("发货/收货单明细id")
    private Long relateDocDid;

    @ApiModelProperty("来源单据明细表ID")
    private Long optDocDtlId;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("发货日期")
    private LocalDateTime shipTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("销/退订单号")
    private String logisDocNo;

    @ApiModelProperty("订单类型")
    private String relateDocType;

    @ApiModelProperty("订单日期")
    private LocalDateTime soDate;

    @ApiModelProperty("下单渠道类型")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String soSource;
    private String soSourceName;

    @ApiModelProperty("是否赠品")
    private String giftsFlag;

    @ApiModelProperty("本次对账数量")
    private BigDecimal soaQty;

    @ApiModelProperty("折扣后主含税单价")
    private BigDecimal discountPrice;

    @ApiModelProperty("对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty("发票折扣率")
    private BigDecimal invDiscount;

    @ApiModelProperty("可开票税额")
    private BigDecimal invTaxAmt;

    @ApiModelProperty("可开票未税金额")
    private BigDecimal invNetAmt;

    @ApiModelProperty("原主含税单价")
    private BigDecimal mainPrice;

    @ApiModelProperty("单品折扣")
    private BigDecimal itemDiscount;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("待开发票id")
    private Long invoiceAwaitId;

}
