package com.elitesland.fin.application.facade.vo.writeoff;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询结果.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "查询结果")
public class FinArRecVerApplyArHeadVO extends CustomFieldBaseModelVo {

    private static final long serialVersionUID = -2783888018637176443L;

    @ApiModelProperty(value = "内外部客户")
    @SysCode(sys = "yst-sale", mod = "CUST_IN_OUT")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
    @ApiModelProperty("关联公司名称")
    private String relevanceOuName;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("应收单编号")
    private String arOrderNo;

    @ApiModelProperty("")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核日期")
    private LocalDateTime auditDate;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("部门ID")
    private Long buId;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("业务类型")
    private String buType;

    @ApiModelProperty("付款条件")
    private String payMentName;

    @ApiModelProperty("付款条件id")
    private String payMentId;

    @ApiModelProperty("付款条件code")
    private String payMentCode;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("单据类型")
    private String arOrderType;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("传SO代表正向，传RSO代表退货负向")
    private String docCls;

    @ApiModelProperty("扩展表关联id")
    private Long relateId;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty("订单客户")
    private String orderCustomer;

    @ApiModelProperty("发票号")
    private String invoiceNumber;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty(value = "发票类型")
    @SysCode(sys = "yst-oldcityfood-interact", mod = "IVN_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty("起算日期")
    private LocalDateTime startDate;

    @ApiModelProperty("红冲标志")
    private Boolean redFlushSign;

    @ApiModelProperty("第三方支付辅助")
    private String thirdPaymentAssistance;

    @ApiModelProperty("消费卡辅助")
    private String consumerCardSsistance;

    @ApiModelProperty("信用卡辅助")
    private String creditCardAssistance;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmting;

    @ApiModelProperty(value = "应收单明细")
    private List<FinArRecVerApplyArVO> arList;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty(value = "业务员")
    private String salesmanName;

}
