package com.elitesland.fin.application.service.expense;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpTypeConvert;
import com.elitesland.fin.application.convert.expense.ExpTypeDtlConvert;
import com.elitesland.fin.application.facade.param.expense.ExpTypeParam;
import com.elitesland.fin.application.facade.vo.expense.ExpTypeDtlVO;
import com.elitesland.fin.application.facade.vo.expense.ExpTypeVO;
import com.elitesland.fin.domain.expense.ExpType;
import com.elitesland.fin.domain.expense.ExpTypeDtl;
import com.elitesland.fin.domain.param.expense.ExpTypeDtlPageParam;
import com.elitesland.fin.domain.param.expense.ExpTypePageParam;
import com.elitesland.fin.domain.service.expense.ExpTypeDomainService;
import com.elitesland.fin.domain.service.expense.ExpTypeDtlDomainService;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDtlDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/8/08 16:27
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ExpTypeServiceImpl implements ExpTypeService {

    private final ExpTypeDomainService expTypeDomainService;
    private final ExpTypeDtlDomainService expTypeDtlDomainService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> save(ExpTypeParam expTypeParam) {
        ExpType expType = ExpTypeConvert.INSTANCE.convert(expTypeParam);
        if (CollectionUtil.isNotEmpty(expTypeParam.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList =
                    expTypeParam.getDtlList().stream().map(ExpTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            expType.setDtlList(expTypeDtlList);
        }
        Long res = expTypeDomainService.save(expType);
        return ApiResult.ok(res);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> update(ExpTypeParam expTypeParam) {
        if (null == expTypeParam.getId()) {
            throw new BusinessException("主键id不能为空");
        }
        ExpType expType = ExpTypeConvert.INSTANCE.convert(expTypeParam);
        if (CollectionUtil.isNotEmpty(expTypeParam.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList =
                    expTypeParam.getDtlList().stream().map(ExpTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            expType.setDtlList(expTypeDtlList);
        }
        Long res = expTypeDomainService.update(expType);
        return ApiResult.ok(res);
    }

    @Override
    @SysCodeProc
    public ApiResult<ExpTypeVO> get(Long id) {
        ExpTypeDTO res = expTypeDomainService.get(id);
        ExpTypeVO expTypeVO = ExpTypeConvert.INSTANCE.convert(res);
        List<ExpTypeDtlDTO> expTypeDtlDTOList = expTypeDtlDomainService.selectByMasId(res.getId());
        if (CollectionUtil.isNotEmpty(expTypeDtlDTOList)) {
            List<ExpTypeDtlVO> expTypeDtlVOList =
                    expTypeDtlDTOList.stream().map(ExpTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
            expTypeVO.setDtlList(expTypeDtlVOList);
        }
        return ApiResult.ok(expTypeVO);
    }

    @Override
    @SysCodeProc
    public ApiResult<PagingVO<ExpTypeVO>> page(ExpTypePageParam expTypePageParam) {
        if (StringUtils.isNotBlank(expTypePageParam.getSourceDoc()) || CollectionUtil.isNotEmpty(expTypePageParam.getSourceDocList())) {
            List<String> sourceDocList = new ArrayList<>();
            if (StringUtils.isNotBlank(expTypePageParam.getSourceDoc())) {
                sourceDocList.add(expTypePageParam.getSourceDoc());
            }
            if (CollectionUtil.isNotEmpty(expTypePageParam.getSourceDocList())) {
                sourceDocList.addAll(expTypePageParam.getSourceDocList());
            }

            ExpTypeDtlPageParam expTypeDtlPageParam = new ExpTypeDtlPageParam();
            expTypeDtlPageParam.setSourceDocList(sourceDocList);
            List<ExpTypeDtlDTO> expTypeDtlDTOList = expTypeDtlDomainService.selectListByParam(expTypeDtlPageParam);
            if (CollectionUtil.isEmpty(expTypeDtlDTOList)) {
                return ApiResult.ok(PagingVO.<ExpTypeVO>builder().total(0L).records(Collections.EMPTY_LIST).build());
            }
            List<Long> masIds =
                    expTypeDtlDTOList.stream().map(ExpTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            expTypePageParam.setIdList(masIds);
        }

        PagingVO<ExpTypeDTO> res = expTypeDomainService.page(expTypePageParam);
        return ApiResult.ok(ExpTypeConvert.INSTANCE.convertPage(res));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, boolean enable) {
        List<ExpTypeDTO> expTypeDTOS = expTypeDomainService.findByIds(ids);
        if (enable) {
            checkEnableRule(expTypeDTOS);
        }
        if (!enable) {
            checkStopRule(expTypeDTOS);
        }
        Boolean res = expTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> updateDef(Long id) {
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> del(Long id) {
        /*// 查询是否已被公司使用
        List<ArTypeOuDTO> arTypeOuDTOS = expTypeOuDomainService.queryByArTypeId(id);
        if (CollUtil.isNotEmpty(arTypeOuDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                    "该数据已分配公司!");
        }
        Boolean aBoolean = arOrderDomainService.queryByArTypeId(id);
        if (aBoolean) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                    "该数据已关联应收单!");
        }*/

        Long res = expTypeDomainService.del(id);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<List<ExpTypeVO>> getList() {
        return ApiResult.ok(ExpTypeConvert.INSTANCE.convertList(expTypeDomainService.getList()));
    }

    @Override
    public ApiResult<ExpTypeVO> getDef() {
        return null;
    }


    /**
     * 停用状态校验
     */
    private void checkStopRule(List<ExpTypeDTO> expTypeDTOS) {
        for (ExpTypeDTO expTypeDTO : expTypeDTOS) {
            // 停用需是启用状态
            if (!expTypeDTO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                        "已停用状态不能再停用");
            }
        }
    }

    /**
     * 启用状态校验
     */
    private void checkEnableRule(List<ExpTypeDTO> expTypeDTOS) {

        for (ExpTypeDTO expTypeDTO : expTypeDTOS) {
            // 启用需是停用状态
            if (expTypeDTO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                        "已启用状态不能再启动");
            }
            // 启用需校验已分配公司
           /* List<ArTypeOuDTO> arTypeOuDTOS = expTypeOuDomainService.queryByArTypeId(expTypeDTO.getId());
            if (CollUtil.isEmpty(arTypeOuDTOS)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,
                        "类型代码" + expTypeDTO.getArTypeCode() + "启用前需要分配公司");
            }*/

        }

    }
}
