package com.elitesland.fin.entity.financial;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2025/10/14 11:50
 */
@Entity
@Table(name = "financial_bill_d")
@org.hibernate.annotations.Table(appliesTo = "financial_bill_d", comment = "账单明细")
@Data
@Where(clause = "delete_flag = 0")
@ApiModel(value = "financial_bill_d", description = "账单明细")
public class FinancialBillDDO extends BaseModel implements Serializable {

    @Column
    @ApiModelProperty("账单类型")
    private String detailBillType;

    @Column
    @ApiModelProperty("明细金额（标准）")
    private BigDecimal detailStandardAmount;


    @Column
    @ApiModelProperty("明细金额（减免）")
    private BigDecimal detailReductionAmount;

    @Column
    @ApiModelProperty("明细金额（实收）")
    private BigDecimal detailActualAmount;

    @Column
    @ApiModelProperty("实收未税金额")
    private BigDecimal amt;

    @Column
    @ApiModelProperty("实收税额")
    private BigDecimal netAmt;

    @Column
    @ApiModelProperty("账单ID")
    private Long masId;
}
