package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎数据行明细")
public class FinAccEngDetDataLineParam extends BaseModelParam {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("字段名称")
    private String columnName;

    @ApiModelProperty("字段类型")
    private String columnType;

    @ApiModelProperty("字段长度")
    private Integer columnLength;

    @ApiModelProperty("字段含义")
    private String columnComment;

    @ApiModelProperty("来源类型")
    private String sourceType;

    @ApiModelProperty("常数")
    private String constant;

    @ApiModelProperty("列来源")
    private String columnSource;

    @ApiModelProperty("输出字段")
    private String outputColumn;

    @ApiModelProperty("值集编码")
    private String flexibleCode;

    @ApiModelProperty("快码编码")
    private String fastCode;

    @ApiModelProperty("组合编码")
    private String abstractCode;
}
