package com.elitesland.fin.application.facade.param.financial;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 充值单;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@Data
@ApiModel(description = "账单")
public class FinancialBillPageParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -5534428658178696764L;
    @ApiModelProperty("主键ID")
    private List<Long> ids;

    @ApiModelProperty("流程ID")
    private String msyWorkId;

    @ApiModelProperty("关联门店(项目)")
    private String msyStoreId;

    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTimeStart;
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("经营性质")
    private String storeType;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("收款公司")
    private String ouCode;

    @ApiModelProperty("拟定状态")
    private String draftStatus;

    @ApiModelProperty("传账状态")
    private String postingStatus;

    @ApiModelProperty("红冲状态")
    private String redStatus;


}