package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_account_engine_details")
@org.hibernate.annotations.Table(appliesTo = "fin_account_engine_details", comment = "会计引擎明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccountEngineDetailsDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "serial_num", columnDefinition = "int(6) comment '序列号'")
    private Integer serialNum;

    @Column(name = "account_engine", columnDefinition = "varchar(256) comment '会计引擎名称'")
    private String accountEngine;

    @Column(name = "active_flag", columnDefinition = "tinyint(1) comment '是否启用'")
    private Boolean activeFlag;

    @Column()
    @Comment("拟定类型")
    private String proposedType;

    @Column()
    @Comment("传帐类型")
    private String transferType;
}
