package com.elitesland.fin.infr.factory.arverrec;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.param.arverrec.ArVerRecPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arverrec.ArVerRecDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.arverrec.ArVerRecDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/4/26 14:47
 */
@RequiredArgsConstructor
@Component
public class ArVerRecFactory {

    private final ArVerRecDtlRepoProc arVerRecDtlRepoProc;

    private final ArOrderRepoProc arOrderRepoProc;

    private final RecOrderRepoProc recOrderRepoProc;

    public PagingVO<ArVerRecDtlDTO> page(ArVerRecPageParam pageParam){
        PagingVO<ArVerRecDtlDTO> page = arVerRecDtlRepoProc.page(pageParam);
        List<ArVerRecDtlDTO> records = page.getRecords();
        List<Long> payIds = records.stream().filter(t -> t.getOrderType().equals(FinConstant.REC)).map(ArVerRecDtlDTO::getOrderId).collect(Collectors.toList());
        if(CollUtil.isNotEmpty(payIds)){
            Map<Long, RecOrderDTO> recOrderDTOMap = recOrderRepoProc.queryByIds(payIds).stream().collect(Collectors.toMap(RecOrderDTO::getId, t -> t));
            records.forEach(t->{
                if(recOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(recOrderDTOMap.get(t.getOrderId()).getTotalAmt());
                    t.setVerState(recOrderDTOMap.get(t.getOrderId()).getVerState());
                    t.setVerAmt(recOrderDTOMap.get(t.getOrderId()).getVerAmt());
                }
            });
        }
        List<Long> apIds = records.stream().filter(t -> t.getOrderType().equals(FinConstant.AR)).map(ArVerRecDtlDTO::getOrderId).collect(Collectors.toList());
        if(CollUtil.isNotEmpty(apIds)){
            Map<Long, ArOrderDTO> arOrderDTOMap = arOrderRepoProc.queryByIds(apIds).stream().collect(Collectors.toMap(ArOrderDTO::getId, t -> t));
            records.forEach(t->{
                if(arOrderDTOMap.containsKey(t.getOrderId())) {
                    t.setTotalAmt(arOrderDTOMap.get(t.getOrderId()).getTotalAmt());
                    t.setVerState(arOrderDTOMap.get(t.getOrderId()).getVerState());
                    t.setVerAmt(arOrderDTOMap.get(t.getOrderId()).getVerAmt());
                }
            });
        }
        return page;
    }
}
