/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.springframework.util.StringUtils;

public class TimeUtil {
    private static String datePattern = "yyyy-MM-dd";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat(datePattern);

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCron(Date date) {
        String dateFormat = "ss mm HH dd MM ?";
        return TimeUtil.formatDateByPattern(date, dateFormat);
    }

    public static String dateToYmd(LocalDate date) {
        return date == null ? "" : date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate dateFromYmd(String ymd) {
        return StringUtils.isEmpty((Object)ymd) ? null : LocalDate.parse(ymd, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String date2String(LocalDate date) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate now = LocalDate.now();
        return format.format(now);
    }

    public static LocalDate string2Date(String yyyyMMdd) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(yyyyMMdd, format);
    }

    public static String time2String(LocalTime time) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("HHmmss");
        LocalTime now = LocalTime.now();
        return format.format(now);
    }

    public static String datetime2String(LocalDateTime localDateTime) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime now = LocalDateTime.now();
        return format.format(now);
    }

    public static LocalDateTime getFirstOfYear(LocalDateTime dateTime) {
        int currentYear = dateTime.getYear();
        Date date = TimeUtil.getFirstOfYear(currentYear);
        LocalDate format = TimeUtil.format(date);
        LocalDateTime firstOfYear = LocalDateTime.of(format, LocalTime.MIN);
        return firstOfYear;
    }

    public static LocalDateTime getLastOfYear(LocalDateTime dateTime) {
        int currentYear = dateTime.getYear();
        Date date = TimeUtil.getLastOfYear(currentYear);
        LocalDate format = TimeUtil.format(date);
        LocalDateTime lastOfYear = LocalDateTime.of(format, LocalTime.MAX);
        return lastOfYear;
    }

    public static Date getFirstOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static LocalDate format(Date date) {
        String format = simpleDateFormat.format(date);
        LocalDate localDate = LocalDate.parse(format);
        return localDate;
    }

    public static Date getLastOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }
}

