package com.elitesland.fin.application.convert.financial;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyArHeadSaveDTO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.dto.arorder.ArOrderRpcDTO;
import com.elitesland.fin.dto.financial.FinancialBillRpcDTO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.param.arorder.ArOrderHandleRpcParam;
import com.elitesland.fin.param.arorder.ArOrderPageRpcParam;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @date 2022/3/16 16:14
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface FinancialBillConvert {

    FinancialBillConvert INSTANCE = Mappers.getMapper(FinancialBillConvert.class);

    PagingVO<FinancialBillVO> convertPage(PagingVO<FinancialBillDTO> param);

    FinancialBillDTO doToDto(FinancialBillDO financialBillDO);

    FinancialBillVO dtoToVo(FinancialBillDTO financialBillDTO);

    FinancialBillDO saveToDos(FinancialBillSaveParam financialBillSaveParams);

    FinancialBillDO dtoToDo(FinancialBillDTO financialBillDTO);

    List<FinancialBillSaveParam> dtoToParam(List<FinancialBillRpcDTO> financialBillRpcDTOS);
}
