package com.elitesland.fin.infr.dto.common;

import com.elitesland.fin.common.UdcEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/4/27 9:42
 */
@Data
public class ArVerDTO {
    private Long id;

    private BigDecimal totalAmt;

    private BigDecimal verAmt;

    private BigDecimal amt;

    private String verState;

    private Integer auditDataVersion;

    public void setAmtAndVerState(BigDecimal amt){
        this.setAmt(amt);
        this.setVerAmt(this.verAmt.add(amt));
        if (this.verAmt.compareTo(this.totalAmt) == 0) {
            this.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
        } else if (this.verAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
        } else {
            this.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
        }
    }
}
