package com.elitesland.fin.repo.payment;


import com.elitesland.fin.entity.payment.PaymentRuleConfigDtlDO;
import com.elitesland.fin.entity.payment.QPaymentRuleConfigDtlDO;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Slf4j
@Component
@AllArgsConstructor
public class PaymentRuleConfigDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPaymentRuleConfigDtlDO jpaQDO = QPaymentRuleConfigDtlDO.paymentRuleConfigDtlDO;

    public void updateDynamically(List<PaymentRuleConfigDtlDO> PaymentRuleConfigDtlDOList) {
        for (PaymentRuleConfigDtlDO param : PaymentRuleConfigDtlDOList) {
            JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);
            updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
            updateClause.where(jpaQDO.id.eq(param.getId())).execute();
        }
    }

    public void deleteByParam(PaymentRuleConfigDtlDO PaymentRuleConfigDtlDO) {
        JPADeleteClause jpaDeleteClause = jpaQueryFactory.delete(jpaQDO);
        if (PaymentRuleConfigDtlDO.getMasId() != null) {
            jpaDeleteClause.where(jpaQDO.masId.eq(PaymentRuleConfigDtlDO.getMasId()));
        }
        jpaDeleteClause.execute();
    }

}