/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.excel.creditaccount.CreditAccountImportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.constant.AllowShipCustGroupEnum;
import com.elitesland.sale.constant.AllowShipStatus;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreditAccountImportServiceImpl
implements DataImport<CreditAccountImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountImportServiceImpl.class);
    private final CreditAccountRepo creditAccountRepo;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final SystemRpcService systemRpcService;
    private final UdcProvider udcProvider;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";

    public String getTmplCode() {
        return "yst_fin_credit_account_import";
    }

    public List<String> executeImport(List<CreditAccountImportEntity> dataList, int rowId) {
        if (CollectionUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        Map udcCodeMap = this.udcProvider.getValueMapByUdcCode(UdcEnum.OBJECT_TYPE_CUST_GROUP.getModel(), Set.of(UdcEnum.OBJECT_TYPE_CUST_GROUP.getCode(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode()));
        Map<String, String> objectNameTypeMap = ((Map)udcCodeMap.get(UdcEnum.OBJECT_TYPE_CUST_GROUP.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        Map<String, String> accountNameTypeMap = ((Map)udcCodeMap.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        List ouCodeList = dataList.stream().map(CreditAccountImportEntity::getOuCode).collect(Collectors.toList());
        OrgOuRpcDtoParam ouParam = new OrgOuRpcDtoParam();
        ouParam.setOuCodes(ouCodeList);
        List<OrgOuRpcDTO> ouRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(ouParam);
        Map<String, OrgOuRpcDTO> ouMap = ouRpcDTOList.stream().collect(Collectors.toMap(OrgOuRpcDTO::getOuCode, t -> t, (t1, t2) -> t1));
        AllowShipCustGroupDParam custParam = new AllowShipCustGroupDParam();
        List<String> custCodeList = dataList.stream().filter(item -> StrUtil.equals((CharSequence)item.getObjectTypeName(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST.getValueCodeName())).map(CreditAccountImportEntity::getObjectCode).collect(Collectors.toList());
        custParam.setCustCodes(custCodeList);
        List<AllowShipCustGroupDVO> custInfo = this.getAllowShipCustGroupInfo(custParam);
        Map<Object, Object> custGroupMap = new HashMap();
        if (CollectionUtil.isNotEmpty(custInfo)) {
            custGroupMap = custInfo.stream().collect(Collectors.toMap(AllowShipCustGroupDVO::getCustCode, AllowShipCustGroupDVO::getCode));
        }
        List<LmSaveCustRespVO> invCust = this.rmiSaleRpcService.findInvCust(custCodeList);
        Map<Object, Object> custMap = Map.of();
        if (CollectionUtil.isNotEmpty(invCust)) {
            custMap = invCust.stream().collect(Collectors.toMap(LmSaveCustRespVO::getCustCode, LmSaveCustRespVO::getCustName, (t1, t2) -> t1));
        }
        AllowShipCustGroupDParam groupDParam = new AllowShipCustGroupDParam();
        List custGroupCodeList = dataList.stream().filter(item -> StrUtil.equals((CharSequence)item.getObjectTypeName(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST_GROUP.getValueCodeName())).map(CreditAccountImportEntity::getObjectCode).collect(Collectors.toList());
        groupDParam.setCodes(custGroupCodeList);
        List<AllowShipCustGroupDVO> custGroupInfo = this.getAllowShipCustGroupInfo(groupDParam);
        HashMap groupMap = new HashMap();
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(custGroupInfo)) {
            map = custGroupInfo.stream().collect(Collectors.groupingBy(AllowShipCustGroupDVO::getCode));
            map.forEach((key, values) -> {
                List custCodes = values.stream().map(item -> item.getCustCode()).collect(Collectors.toList());
                groupMap.put(key, custCodes);
            });
        }
        ArrayList<CreditAccountImportEntity> saveList = new ArrayList<CreditAccountImportEntity>();
        ArrayList<String> errorResult = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<CallSite> uniList = new ArrayList<CallSite>();
        for (CreditAccountImportEntity data : dataList) {
            String key2;
            ArrayList<String> errorList = new ArrayList<String>();
            this.checkImportMandatoryField(data, errorList, rowId);
            if (StrUtil.isNotBlank((CharSequence)data.getCreditAccountTypeName()) && accountNameTypeMap.containsKey(data.getCreditAccountTypeName())) {
                data.setCreditAccountType(accountNameTypeMap.get(data.getCreditAccountTypeName()));
            } else {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fe1\u7528\u8d26\u6237\u7c7b\u578b", "\u4fe1\u7528\u8d26\u6237\u7c7b\u578b\uff0c\u4e0d\u6b63\u786e"));
            }
            if (StrUtil.isNotBlank((CharSequence)data.getObjectTypeName()) && objectNameTypeMap.containsKey(data.getObjectTypeName())) {
                data.setObjectType(objectNameTypeMap.get(data.getObjectTypeName()));
            } else {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5bf9\u8c61\u7c7b\u578b", "\u5bf9\u8c61\u7c7b\u578b\uff0c\u4e0d\u6b63\u786e"));
            }
            if (CollectionUtil.isNotEmpty(ouMap) && ouMap.containsKey(data.getOuCode())) {
                data.setOuId(ouMap.get(data.getOuCode()).getId());
                data.setOuName(ouMap.get(data.getOuCode()).getOuName());
            } else {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6388\u4fe1\u7ec4\u7ec7(\u516c\u53f8\u7f16\u7801)", "\u6ca1\u6709\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f"));
            }
            if (StrUtil.isNotBlank((CharSequence)data.getCreditAccountName()) && this.creditAccountRepo.existsByCreditAccountName(data.getCreditAccountName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u5df2\u5b58\u5728"));
            }
            if (nameList.contains(data.getCreditAccountName())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u91cd\u590d"));
            }
            nameList.add(data.getCreditAccountName());
            String code = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "XYZH", new ArrayList<String>());
            data.setCreditAccountCode(code);
            if (StrUtil.isNotBlank((CharSequence)data.getOuCode()) && StrUtil.isNotBlank((CharSequence)data.getObjectCode()) && this.creditAccountRepo.existsByObjectCodeAndOuCode(data.getObjectCode(), data.getOuCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "", "\u8be5\u5bf9\u8c61\u7f16\u7801\u548c\u516c\u53f8\u4e0b\u5df2\u6709\u8d26\u6237\u5b58\u5728"));
            }
            if (uniList.contains(key2 = data.getOuCode() + data.getObjectTypeName() + data.getObjectCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "", "\u516c\u53f8/\u5ba2\u6237\u7c7b\u578b/\u5ba2\u6237\u7f16\u7801 \u91cd\u590d"));
            }
            uniList.add((CallSite)((Object)key2));
            if (StrUtil.equals((CharSequence)data.getObjectTypeName(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST.getValueCodeName()) && StrUtil.isNotBlank((CharSequence)data.getObjectCode())) {
                String groupCode;
                if (custGroupMap.containsKey(data.getObjectCode()) && this.creditAccountRepo.existsByObjectCodeAndOuCode(groupCode = (String)custGroupMap.get(data.getObjectCode()), data.getObjectCode())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5bf9\u8c61\u7f16\u7801", "\u5ba2\u6237\u6240\u5c5e\u5ba2\u6237\u7ec4\u5df2\u5b58\u5728\u8d26\u6237"));
                }
                if (custMap.containsKey(data.getObjectCode())) {
                    data.setObjectName((String)custMap.get(data.getObjectCode()));
                }
            }
            if (StrUtil.equals((CharSequence)data.getObjectTypeName(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST_GROUP.getValueCodeName()) && StrUtil.isNotBlank((CharSequence)data.getObjectCode())) {
                if (groupMap.containsKey(data.getObjectCode())) {
                    List custCodes = (List)groupMap.get(data.getObjectCode());
                    if (this.creditAccountRepo.existsByObjectCodeInAndOuCode(custCodes, data.getOuCode())) {
                        errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5bf9\u8c61\u7f16\u7801", "\u8be5\u5ba2\u6237\u7ec4\u5df2\u6709\u5ba2\u6237\u521b\u5efa\u8d26\u6237\uff0c\u8bf7\u8c03\u6574"));
                    }
                    List group = (List)map.get(data.getObjectCode());
                    data.setObjectName(((AllowShipCustGroupDVO)group.get(0)).getName());
                } else {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5bf9\u8c61\u7f16\u7801", "\u6ca1\u6709\u67e5\u8be2\u5230\u5ba2\u6237\u7ec4\u4fe1\u606f"));
                }
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            } else {
                errorResult.add(null);
                saveList.add(data);
            }
            ++rowId;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.saveData(saveList);
            return CollectionUtil.isNotEmpty(errorResult) ? errorResult : null;
        }
        return errorResult;
    }

    private void checkImportMandatoryField(CreditAccountImportEntity data, List<String> errorList, int rowId) {
        if (StrUtil.isBlank((CharSequence)data.getCreditAccountTypeName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u4fe1\u7528\u8d26\u6237\u7c7b\u578b", "\u4fe1\u7528\u8d26\u6237\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)data.getObjectTypeName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5bf9\u8c61\u7c7b\u578b", "\u5bf9\u8c61\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)data.getOuCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6388\u4fe1\u7ec4\u7ec7(\u516c\u53f8\u7f16\u7801)", "\u6388\u4fe1\u7ec4\u7ec7(\u516c\u53f8\u7f16\u7801)\uff0c\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)data.getCreditAccountName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtil.isBlank((CharSequence)data.getObjectCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u5bf9\u8c61\u7f16\u7801", "\u5bf9\u8c61\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    public void saveData(List<CreditAccountImportEntity> saveList) {
        List<CreditAccountDO> doList = CreditAccountConvert.INSTANCE.importEntitys2Dos(saveList);
        this.creditAccountRepo.saveAll(doList);
    }

    private List<AllowShipCustGroupDVO> getAllowShipCustGroupInfo(AllowShipCustGroupDParam groupDParam) {
        groupDParam.setType(AllowShipCustGroupEnum.CREIDT_ACCOUNT_GROUP.getType());
        groupDParam.setStatus(AllowShipStatus.ACTIVE.getType());
        List<AllowShipCustGroupDVO> custGroupInfo = this.rmiSaleRpcService.getCustGroupInfo(groupDParam);
        return custGroupInfo;
    }

    public CreditAccountImportServiceImpl(CreditAccountRepo creditAccountRepo, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, RmiSaleRpcService rmiSaleRpcService, SystemRpcService systemRpcService, UdcProvider udcProvider, CreditAccountRepoProc creditAccountRepoProc) {
        this.creditAccountRepo = creditAccountRepo;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.systemRpcService = systemRpcService;
        this.udcProvider = udcProvider;
        this.creditAccountRepoProc = creditAccountRepoProc;
    }
}

