/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.expense;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpTypeDtlConvert;
import com.elitesland.fin.domain.expense.ExpTypeDtl;
import com.elitesland.fin.domain.expense.ExpTypeDtlDO;
import com.elitesland.fin.domain.param.expense.ExpTypeDtlPageParam;
import com.elitesland.fin.domain.service.expense.ExpTypeDtlDomainService;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDtlDTO;
import com.elitesland.fin.infr.repo.expense.ExpTypeDtlRepo;
import com.elitesland.fin.infr.repo.expense.ExpTypeDtlRepoProc;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExpTypeDtlDomainServiceImpl
implements ExpTypeDtlDomainService {
    private static final Logger log = LoggerFactory.getLogger(ExpTypeDtlDomainServiceImpl.class);
    private final ExpTypeDtlRepo expTypeDtlRepo;
    private final ExpTypeDtlRepoProc expTypeDtlRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(List<ExpTypeDtl> dtlList) {
        List expTypeDtlDOList = dtlList.stream().map(ExpTypeDtlConvert.INSTANCE::enToDo).collect(Collectors.toList());
        this.expTypeDtlRepo.saveAll(expTypeDtlDOList);
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDtlDTO> selectByMasId(Long masId) {
        List<ExpTypeDtlDO> expTypeDtlDOList = this.expTypeDtlRepo.findAllByMasId(masId);
        if (CollectionUtil.isEmpty(expTypeDtlDOList)) {
            return Collections.EMPTY_LIST;
        }
        List<ExpTypeDtlDTO> expTypeDtlDTOList = expTypeDtlDOList.stream().map(ExpTypeDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());
        return expTypeDtlDTOList;
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDtlDTO> selectByMasIds(List<Long> masIds) {
        List<ExpTypeDtlDO> expTypeDtlDOList = this.expTypeDtlRepo.findAllByMasIdIn(masIds);
        if (CollectionUtil.isEmpty(expTypeDtlDOList)) {
            return Collections.EMPTY_LIST;
        }
        List<ExpTypeDtlDTO> expTypeDtlDTOList = expTypeDtlDOList.stream().map(ExpTypeDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());
        return expTypeDtlDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<ExpTypeDtlDTO> page(ExpTypeDtlPageParam pageParam) {
        PagingVO<ExpTypeDtlDTO> pagingVO = this.expTypeDtlRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIdBatch(List<Long> ids) {
        this.expTypeDtlRepo.deleteAllByMasIdIn(ids);
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDtlDTO> selectListByParam(ExpTypeDtlPageParam pageParam) {
        List<ExpTypeDtlDTO> expTypeDtlDTOList = this.expTypeDtlRepoProc.selectListByParam(pageParam);
        if (CollectionUtils.isEmpty(expTypeDtlDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return expTypeDtlDTOList;
    }

    public ExpTypeDtlDomainServiceImpl(ExpTypeDtlRepo expTypeDtlRepo, ExpTypeDtlRepoProc expTypeDtlRepoProc) {
        this.expTypeDtlRepo = expTypeDtlRepo;
        this.expTypeDtlRepoProc = expTypeDtlRepoProc;
    }
}

