/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.financial;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.financial.FinancialBillConvert;
import com.elitesland.fin.application.convert.financial.FinancialBillDConvert;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDDTO;
import com.elitesland.fin.application.facade.dto.financial.FinancialBillDTO;
import com.elitesland.fin.application.facade.param.financial.FinancialBillDSaveParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillPageParam;
import com.elitesland.fin.application.facade.param.financial.FinancialBillSaveParam;
import com.elitesland.fin.application.facade.vo.financial.FinancialBillVO;
import com.elitesland.fin.application.service.financial.FinancialBillService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.financial.FinancialBillDDomainService;
import com.elitesland.fin.domain.service.financial.FinancialBillDomainService;
import com.elitesland.fin.entity.financial.FinancialBillDDO;
import com.elitesland.fin.entity.financial.FinancialBillDO;
import com.elitesland.fin.repo.financial.FinancialBillDRepo;
import com.elitesland.fin.repo.financial.FinancialBillRepo;
import com.elitesland.fin.repo.financial.FinancialBillRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreLicenseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FinancialBillServiceImpl
implements FinancialBillService {
    private static final Logger log = LoggerFactory.getLogger(FinancialBillServiceImpl.class);
    private final FinancialBillDomainService financialBillDomainService;
    private final FinancialBillDDomainService financialBillDDomainService;
    private final SysUdcProxyService sysUdcProxyService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final FinancialBillRepo financialBillRepo;
    private final FinancialBillRepoProc financialBillRepoProc;
    private final FinancialBillDRepo financialBillDRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinancialBillVO> pageSearch(FinancialBillPageParam financialBillPageParam) {
        PagingVO<FinancialBillVO> financialBillVOPagingVO = FinancialBillConvert.INSTANCE.convertPage(this.financialBillDomainService.page(financialBillPageParam));
        List<String> ouCodes = financialBillVOPagingVO.getRecords().stream().map(FinancialBillVO::getOuCode).collect(Collectors.toList());
        Map<String, String> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuByCodes(ouCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, OrgOuRpcSimpleDTO::getOuName));
        financialBillVOPagingVO.getRecords().forEach(vo -> {
            if (ouMap.get(vo.getOuCode()) != null) {
                vo.setOuName((String)ouMap.get(vo.getOuCode()));
            }
        });
        return financialBillVOPagingVO;
    }

    @Override
    @SysCodeProc
    public FinancialBillVO get(Long id) {
        FinancialBillDTO financialBillDTO = this.financialBillDomainService.get(id);
        List<FinancialBillDDTO> financialBillDDTOS = this.financialBillDDomainService.queryByMasId(id);
        this.sysUdcProxyService.translate(financialBillDDTOS);
        financialBillDTO.setFinancialBillDList(financialBillDDTOS);
        return FinancialBillConvert.INSTANCE.dtoToVo(financialBillDTO);
    }

    @Override
    @Transactional
    public void batchSaveFinancialBill(List<FinancialBillSaveParam> param) {
        if (!CollectionUtils.isEmpty(param)) {
            ArrayList<FinancialBillDDO> dtlData = new ArrayList<FinancialBillDDO>();
            param.forEach(vo -> {
                FinancialBillDO financialBillDO = FinancialBillConvert.INSTANCE.saveToDos((FinancialBillSaveParam)vo);
                Long save = this.financialBillDomainService.save(financialBillDO);
                vo.getFinancialBillDList().forEach(dtl -> {
                    FinancialBillDDO financialBillDDO = FinancialBillDConvert.INSTANCE.paramToDO((FinancialBillDSaveParam)dtl);
                    financialBillDDO.setMasId(save);
                    dtlData.add(financialBillDDO);
                });
            });
            if (!CollectionUtils.isEmpty(dtlData)) {
                this.financialBillDDomainService.batchSaveFinancialBillD(dtlData);
            }
        }
    }

    @Override
    @Transactional
    public void autoRed() {
        FinancialBillPageParam financialBillPageParam = new FinancialBillPageParam();
        financialBillPageParam.setSize(100000);
        financialBillPageParam.setRedStatus(UdcEnum.FINANCIAL_BILL_RED_STATUS_NONE.getValueCode());
        List records = this.financialBillDomainService.page(financialBillPageParam).getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List storeIds = records.stream().map(FinancialBillDTO::getMsyStoreId).collect(Collectors.toList());
            OrgStoreBaseRpcParam orgStoreBaseRpcParam = new OrgStoreBaseRpcParam();
            orgStoreBaseRpcParam.setMsyStoreId(storeIds);
            List orgStoreBaseRpcDTOS = (List)this.orgStoreRpcService.findOrgStoreBaseByParam(orgStoreBaseRpcParam).getData();
            Map<String, OrgStoreBaseRpcDTO> storeMap = orgStoreBaseRpcDTOS.stream().collect(Collectors.toMap(OrgStoreBaseRpcDTO::getMsyStoreId, t -> t));
            List storeId = orgStoreBaseRpcDTOS.stream().map(OrgStoreBaseRpcDTO::getMsyStoreId).collect(Collectors.toList());
            ArrayList data = new ArrayList();
            records.forEach(vo -> {
                Optional<OrgStoreLicenseRpcDTO> first;
                if (storeMap.get(vo.getMsyStoreId()) != null && (first = ((OrgStoreBaseRpcDTO)storeMap.get(vo.getMsyStoreId())).getOrgStoreLicenseRpcDTOS().stream().filter(v -> "YEZC".equals(v.getLicenseType())).findFirst()).isPresent()) {
                    data.add(vo);
                }
            });
            if (!CollectionUtils.isEmpty(data)) {
                log.info("\u7b26\u5408\u7ea2\u51b2\u7684\u6570\u636e" + JSONObject.toJSONString(data));
                List<Long> ids = data.stream().map(BaseModelVO::getId).collect(Collectors.toList());
                Map<Long, List<FinancialBillDDTO>> dtlMap = this.financialBillDDomainService.queryByMasIdIn(ids).stream().collect(Collectors.groupingBy(FinancialBillDDTO::getMasId));
                ArrayList dtlData = new ArrayList();
                data.forEach(vo -> {
                    FinancialBillDO jms = FinancialBillConvert.INSTANCE.dtoToDo((FinancialBillDTO)vo);
                    jms.setRedStatus(UdcEnum.RED_STATE_NO.getValueCode());
                    jms.setDraftStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                    jms.setRedSource(vo.getMsyDataId());
                    jms.setId(null);
                    jms.setCreator(null);
                    jms.setCreateUserId(null);
                    jms.setCreateTime(null);
                    jms.setUpdater(null);
                    jms.setModifyUserId(null);
                    jms.setModifyTime(null);
                    jms.setPaymentAccountAmount(vo.getPaymentAccountAmount().multiply(new BigDecimal(-1)));
                    FinancialBillDO jmsSave = (FinancialBillDO)this.financialBillRepo.save(jms);
                    FinancialBillDO store = FinancialBillConvert.INSTANCE.dtoToDo((FinancialBillDTO)vo);
                    store.setRedStatus(UdcEnum.RED_STATE_NO.getValueCode());
                    store.setDraftStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
                    store.setRedSource(vo.getMsyDataId());
                    store.setDocType(UdcEnum.FINANCIAL_BILL_TYPE_STORE.getValueCode());
                    store.setId(null);
                    store.setCreator(null);
                    store.setCreateUserId(null);
                    store.setCreateTime(null);
                    store.setUpdater(null);
                    store.setModifyUserId(null);
                    store.setModifyTime(null);
                    store.setStoreCode(((OrgStoreBaseRpcDTO)storeMap.get(vo.getMsyStoreId())).getStoreCode());
                    store.setStoreName(((OrgStoreBaseRpcDTO)storeMap.get(vo.getMsyStoreId())).getStoreName());
                    FinancialBillDO storeSave = (FinancialBillDO)this.financialBillRepo.save(store);
                    if (!CollectionUtils.isEmpty((Collection)((Collection)dtlMap.get(vo.getId())))) {
                        ((List)dtlMap.get(vo.getId())).forEach(dtl -> {
                            FinancialBillDDO jmsFinancialBillDDO = FinancialBillDConvert.INSTANCE.dtoToDo((FinancialBillDDTO)dtl);
                            jmsFinancialBillDDO.setId(null);
                            jmsFinancialBillDDO.setCreator(null);
                            jmsFinancialBillDDO.setCreateUserId(null);
                            jmsFinancialBillDDO.setCreateTime(null);
                            jmsFinancialBillDDO.setUpdater(null);
                            jmsFinancialBillDDO.setModifyUserId(null);
                            jmsFinancialBillDDO.setModifyTime(null);
                            jmsFinancialBillDDO.setMasId(jmsSave.getId());
                            jmsFinancialBillDDO.setDetailActualAmount(dtl.getDetailActualAmount().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setDetailReductionAmount(dtl.getDetailReductionAmount().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setDetailStandardAmount(dtl.getDetailStandardAmount().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setAmt(dtl.getAmt().multiply(new BigDecimal(-1)));
                            jmsFinancialBillDDO.setNetAmt(dtl.getNetAmt().multiply(new BigDecimal(-1)));
                            dtlData.add(jmsFinancialBillDDO);
                            FinancialBillDDO storeFinancialBillDDO = FinancialBillDConvert.INSTANCE.dtoToDo((FinancialBillDDTO)dtl);
                            storeFinancialBillDDO.setId(null);
                            storeFinancialBillDDO.setCreator(null);
                            storeFinancialBillDDO.setCreateUserId(null);
                            storeFinancialBillDDO.setCreateTime(null);
                            storeFinancialBillDDO.setUpdater(null);
                            storeFinancialBillDDO.setModifyUserId(null);
                            storeFinancialBillDDO.setModifyTime(null);
                            storeFinancialBillDDO.setMasId(storeSave.getId());
                            dtlData.add(storeFinancialBillDDO);
                        });
                    }
                });
                if (!CollectionUtils.isEmpty(dtlData)) {
                    this.financialBillDRepo.saveAll(dtlData);
                }
                this.financialBillRepoProc.updateRed(ids);
            }
        }
    }

    public FinancialBillServiceImpl(FinancialBillDomainService financialBillDomainService, FinancialBillDDomainService financialBillDDomainService, SysUdcProxyService sysUdcProxyService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, OrgStoreRpcService orgStoreRpcService, FinancialBillRepo financialBillRepo, FinancialBillRepoProc financialBillRepoProc, FinancialBillDRepo financialBillDRepo) {
        this.financialBillDomainService = financialBillDomainService;
        this.financialBillDDomainService = financialBillDDomainService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.orgStoreRpcService = orgStoreRpcService;
        this.financialBillRepo = financialBillRepo;
        this.financialBillRepoProc = financialBillRepoProc;
        this.financialBillDRepo = financialBillDRepo;
    }
}

