package com.elitesland.fin.application.web.creditaccount;


import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.vo.creditaccount.InitialLimitPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountInitialLimitService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.creditaccount.CreditAccountInitialLimitDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/initial/limit")
@RequiredArgsConstructor
@Api(value = "期初额度余额", tags = {"期初额度余额"})
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_INITIAL_LIMIT, businessDoClass = CreditAccountInitialLimitDO.class)
public class CreditAccountInitialLimitController {

    private final CreditAccountInitialLimitService creditAccountInitialLimitService;

    @PostMapping("/page")
    @ApiOperation("期初额度余额列表查询")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "期初额度余额分页",
            businessObjectType = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_INITIAL_LIMIT,operationCode = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_INITIAL_LIMIT_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<InitialLimitPageVO>> pageSearch(@RequestBody CreditAccountInitialLimitParam pageParam) {
        PagingVO<InitialLimitPageVO> res = creditAccountInitialLimitService.pageSearch(pageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("/finished")
    @ApiOperation("结束初始化")
    public ApiResult<?> finishedInitial(@RequestBody List<Long> ids) {
        creditAccountInitialLimitService.finishedInitial(ids);
        return ApiResult.ok();
    }

    /**
     * 期初额度余额-删除
     * @param ids
     * @return
     */
    @PostMapping("/delete")
    @ApiOperation("期初额度余额-删除")
    public ApiResult delete(@RequestBody List<Long> ids) {
        creditAccountInitialLimitService.delete(ids);
        return ApiResult.ok();
    }
}
