package com.elitesland.fin.application.web.saleinvd;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.saleinvd.SaleInvdService;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.apache.kafka.common.serialization.VoidDeserializer;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author gyj
 * @date 2022/5/6 14:32
 */
@RestController
@RequestMapping("/saleInvd")
@RequiredArgsConstructor
@Api(tags = {"销售已开发票列表"})
public class SaleInvdController {

    public final SaleInvdService saleInvdService;

    @GetMapping("cancel")
    @ApiOperation("作废")
    public ApiResult<Void> cancel(Long id) {
        saleInvdService.cancel(id);
        return ApiResult.ok();
    }

    @GetMapping("/red")
    @ApiOperation("红冲")
    public ApiResult<Void> red(Long id) {
        saleInvdService.red(id);
        return ApiResult.ok();
    }

    @ApiOperation("换开申请")
    @GetMapping("/redraft")
    public ApiResult<InvoiceRedraftPageVO> redraft(Long id) {
        return ApiResult.ok(saleInvdService.redraft(id));
    }


}
