package com.elitesland.fin.application.facade.vo.account;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "账户快照返回值",description = "账户快照返回值")
@Data
public class AccountSnapshotVo extends CustomFieldBaseModelVo {

    @ApiModelProperty("归属公司编码")
    private String secOuCode;

    @ApiModelProperty("归属公司名称")
    private String secOuName;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    @SysCode(sys = "yst-fin", mod = "ACCOUNT_TYPE")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty("账户性质")
    private String accountNature;

    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String state;
    private String stateName;

    @ApiModelProperty("快照时间")
    private LocalDateTime snapshotTime;

}
