package com.elitesland.fin.application.facade.vo.financial;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 充值单;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 */
@ApiModel(value = "账单", description = "")
@Data
public class FinancialBillVO extends BaseModelVO {
    private static final long serialVersionUID = 4643188476671438315L;

    @ApiModelProperty("流程ID")
    private String msyWorkId;

    @ApiModelProperty("流程名称")
    private String msyWorkName;

    @ApiModelProperty("数据ID")
    private String msyDataId;

    @ApiModelProperty("支付节点ID")
    private String msyPayNodeId;
    // 基础信息

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("外部门店ID")
    private String outerStoreId;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-fin", mod = "FINANCIAL_BILL_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("关联门店(项目)")
    private String msyStoreId;


    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType;
    private String storeTypeName;


    @ApiModelProperty("外部加盟商ID")
    private String msyFranchiseeId;


    @ApiModelProperty("加盟商编码")
    private String franchiseeCode;


    @ApiModelProperty("加盟商名称")
    private String franchiseeName;


    @ApiModelProperty("项目编码")
    private String projectNumber;


    @ApiModelProperty("支付方式")
    @SysCode(sys = "yst-fin", mod = "PAY_CHANNEL_TYPE")
    private String paymentChannel;
    private String paymentChannelName;



    @ApiModelProperty("账单ID")
    private String payOrderId;


    @ApiModelProperty("交易流水号（天财商龙）")
    private String orderIdTt;


    @ApiModelProperty("交易流水号（微企付）")
    private String orderIdWqf;


    @ApiModelProperty("收款账户id（天财商龙）")
    private String receivingAccountTt;


    @ApiModelProperty("收款账户（钱包分账）")
    private String receivingAccountQb;


    @ApiModelProperty("收款公司")
    private String ouCode;
    private String ouName;

    @ApiModelProperty("账单类型")
    @SysCode(sys = "yst-fin", mod = "PAY_ORDER_TYPE")
    private String payOrderType;
    private String payOrderTypeName;


    @ApiModelProperty("收款账号")
    private String receivingAccount;


    @ApiModelProperty("收款方户名")
    private String receivingAccountName;


    @ApiModelProperty("付款账户（钱包分账）")
    private String paymentAccountQb;


    @ApiModelProperty("付款人")
    private String paymentAccountName;


    @ApiModelProperty("付款金额")
    private BigDecimal paymentAccountAmount;


    @ApiModelProperty("账单生成时间")
    private LocalDateTime createDate;


    @ApiModelProperty("账单完成时间")
    private LocalDateTime paymentDate;


    @ApiModelProperty("付款凭证附件URL")
    private String url;


    @ApiModelProperty("附件名称")
    private String fileName;


    @ApiModelProperty("红冲来源")
    private String redSource;


    @ApiModelProperty("拟定状态")
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    private String draftStatus;
    private String draftStatusName;


    @ApiModelProperty("红冲状态")
    @SysCode(sys = "yst-fin", mod = "FINANCIAL_BILL_RED_STATUS")
    private String redStatus;
    private String redStatusName;


    @ApiModelProperty("传账状态")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String postingStatus;
    private String postingStatusName;

    @ApiModelProperty("账单明细")
    private List<FinancialBillDVO> financialBillDList;
}