package com.elitesland.fin.application.service.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.*;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.account.*;
import com.elitesland.fin.entity.account.AccountSnapshotDO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.account
 * @date 2023/2/16 09:02
 */
public interface AccountService {

    void save(AccountSaveParam accountSaveParam);

    AccountVO get(Long id);

    PagingVO<AccountVO> page(AccountPageParam accountPageParam);

    List<AccountDTO> getAccountByAccountParam(AccountParam param);


    Long updateState(AccountParam accountParam);

    /**
     * @param accountCodes 账户编码
     * @param type         账户类型
     * @param state        是否启用
     * @return
     */
    List<AccountVO> queryAccount(List<String> accountCodes, String type, String state);

    /**
     * 根据公司
     *
     * @param accCode
     * @return
     */
    AccountVO getByCode(String accCode);

    /**
     * 根据编码更新账户金额
     *
     * @param accCode
     * @param accAmt
     * @param accOccAmt
     * @return
     */
    Boolean updateAmtByCode(String accCode, BigDecimal accAmt, BigDecimal accOccAmt);

    /**
     * 账户导入
     *
     * @param file
     */
    void accountImport(MultipartFile file) throws IOException;

    List<AccountBankInfoVo> getBankByCustCode(String custCode);

    PagingVO<AccountSnapshotVo> querySnapshot(AccountSnapshotParam param);

    void accountSnapshot(String param);

    List<AccountSnapshotDO> selectAccountSnapshotByParam(AccountSnapshotParam queryParam);

    /**
     * 根据客户编码查询账户和信用账户的公司信息
     *
     * @param accountAppParam 入参
     *
     * @return
     */
    List<AccountOuVO> selectOuByParam(AccountAppParam accountAppParam);

    /**
     * 根据客户编码和公司查询账户和信用账户的金额汇总信息
     *
     * @param accountAppParam 入参
     *
     * @return
     */
    AccountAmtSumVO selectAmtSumByParam(AccountAppParam accountAppParam);

    /**
     * 根据客户编码、公司和账户类型查询账户和信用账户的金额和流水信息
     *
     * @param accountAppParam 入参
     *
     * @return
     */
    AccountAmtFlowVO selectAccountAmtAndFlow(AccountAppParam accountAppParam);
}
