package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleVO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinFlexibleServiceImpl implements FinFlexibleService {


    private final FinFlexibleRepo finFlexibleRepo;

    private final FinFlexibleRepoProc finFlexibleRepoProc;

    private final FinFlexibleValueRepo finFlexibleValueRepo;


    @SysCodeProc
    @Override
    public PagingVO<FinFlexibleVO> page(FinFlexibleParam finFlexibleParam) {
        return FinFlexibleConvert.INSTANCE.DTOToVO(finFlexibleRepoProc.page(finFlexibleParam));
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void enableOrDisable(FinFlexibleParam finFlexibleParam) {

        checkEnableOrDisableParam(finFlexibleParam);

        List<FinFlexibleDO> finFlexibleDOList = finFlexibleRepo.findAllById(finFlexibleParam.getIds());
        finFlexibleDOList.stream().forEach(item -> Assert.isFalse(finFlexibleParam.getStatus().equals(item.getStatus()), "数据已经启用/禁用"));

        finFlexibleDOList.stream().forEach(item -> item.setStatus(finFlexibleParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinFlexibleParam finFlexibleParam) {
        Assert.notEmpty(finFlexibleParam.getIds(), "id必填");
        Assert.notEmpty(finFlexibleParam.getStatus(), "状态必填");
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long saveOrUpdate(FinFlexibleParam finFlexibleParam) {

        checkSaveOrUpdateParam(finFlexibleParam);

        checkIdempotent(finFlexibleParam);

        FinFlexibleDO finFlexibleDO = finFlexibleRepo.save(FinFlexibleConvert.INSTANCE.paramToDO(finFlexibleParam));
        finFlexibleValueRepo.deleteAllByMasId(finFlexibleDO.getId());

        List<FinFlexibleValueParam> finFlexibleValueParamList = finFlexibleParam.getDetailList();
        finFlexibleValueParamList.stream().forEach(item -> item.setMasId(finFlexibleDO.getId()));
        finFlexibleValueRepo.saveAll(FinFlexibleValueConvert.INSTANCE.paramToDO(finFlexibleValueParamList));

        return finFlexibleDO.getId();
    }

    private void checkSaveOrUpdateParam(FinFlexibleParam finFlexibleParam) {
        Assert.notEmpty(finFlexibleParam.getFlexibleCode(), "值集编码必填");
        Assert.notEmpty(finFlexibleParam.getFlexibleName(), "值集名称必填");
        Assert.notEmpty(finFlexibleParam.getFlexibleType(), "值集类型必填");
        Assert.notEmpty(finFlexibleParam.getStatus(), "状态必填");

        // 没有明细也可新增
        List<FinFlexibleValueParam> finFlexibleValueParamList = finFlexibleParam.getDetailList();
//        Assert.notEmpty(finFlexibleValueParamList, "值集明细必填");

        if(CollectionUtils.isNotEmpty(finFlexibleValueParamList)){
            finFlexibleValueParamList.stream().forEach(item -> {
                Assert.notNull(item.getSerialNum(), "序号必填");
                Assert.notEmpty(item.getFlexibleValueCode(), "值必填");
                Assert.notEmpty(item.getFlexibleValueName(), "值名称必填");
                Assert.notNull(item.getDescendantsFlag(), "是否有子代必填");
                Assert.notNull(item.getActiveFlag(), "是否启用必填");
                Assert.notNull(item.getAccountFlag(), "是否记账必填");
                Assert.notNull(item.getActiveStartTime(), "起始有效日期必填");
                Assert.notNull(item.getActiveEndTime(), "终止有效日期必填");

                if (StringUtils.isNotEmpty(finFlexibleParam.getParentFlexibleCode())) {
                    Assert.notEmpty(item.getMasFlexibleValueCode(), "主值必填");
                    Assert.notEmpty(item.getMasFlexibleValueName(), "主值名称必填");
                }
            });
        }
    }

    private void checkIdempotent(FinFlexibleParam finFlexibleParam) {

        FinFlexibleDO finFlexibleDO = finFlexibleRepoProc.findByFlexibleCode(finFlexibleParam.getFlexibleCode());

        if (finFlexibleDO != null) {

            Assert.equals(finFlexibleParam.getId(), finFlexibleDO.getId(), "值集编码已经存在");
        }
    }
}
