package com.elitesland.fin.config;

//import com.elitesland.order.service.SalSoReturnRpcService;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitesland.fin.application.facade.param.arorder.ApArOrderParam;
import com.elitesland.fin.application.facade.param.arorder.ApOrderRefreshParam;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.accountingengine.JournalGenerateService;
import com.elitesland.fin.application.service.arorder.ApArOrderService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountAutoRepaymentService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.expense.ExpenseCalService;
import com.elitesland.fin.application.service.financial.FinancialBillService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 定时
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class JobHandler {

    private final LimitAdjustOrderService limitAdjustOrderService;

    private final InvoiceAwaitService invoiceAwaitService;

    private final CreditAccountService creditAccountService;

    private final AccountService accountService;

    private final FinAccountEngineService finAccountEngineService;

    private final ArOrderService arOrderService;

    private final TenantClientProvider tenantClientProvider;

    private final JournalGenerateService journalGenerateService;

    private final ApArOrderService apArOrderService;

    private final CreditAccountAutoRepaymentService creditAccountAutoRepaymentService;

    private final ExpenseCalService expenseCalService;

    private final FinancialBillService financialBillService;

    @XxlJob(JobConstant.EXPIRE_LIMIT_ADJUST_ORDER)
    public ReturnT<String> expireLimitAdjustOrder(String param) {
        try {
            limitAdjustOrderService.expireLimitAdjustOrder();
        }catch (Exception e){
            XxlJobLogger.log("执行结果:============================"+ e.getMessage());
            return  ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 调整单定时生成流水
     * @param param
     * @return
     */
    @XxlJob(JobConstant.ACTIVE_LIMIT_ADJUST_ORDER)
    public ReturnT<String> activeLimitAdjustOrder(String param) {
        try {
            log.info("登录人信息：{}", SecurityContextUtil.currentUser());
            limitAdjustOrderService.activeLimitAdjustOrder();
        }catch (Exception e){
            XxlJobLogger.log("执行结果:============================"+ e.getMessage());
            return  ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }



    /**
     * 定时生成待开申请发票列表
     * @param param
     * @return
     */
    @XxlJob(JobConstant.INVOICE_AWAIT_ORDER)
    public ReturnT<String> invoiceAwaitOrder(String param) {
        try {
            invoiceAwaitService.invoiceAwaitOrder(param);
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 销售发货单/销售退货收货单生成待开申请发票列表
     * @param param
     * @return
     */
    @XxlJob(JobConstant.INVOICE_AWAIT_ORDER_SAL_DO)
    public ReturnT<String> invoiceAwaitOrderBySalDo(String param) {
        try {
            XxlJobLogger.log("销售发货单/销售退货收货单生成待开申请发票列表开始");
            invoiceAwaitService.invoiceAwaitOrderBySalDo(param);
            XxlJobLogger.log("销售发货单/销售退货收货单生成待开申请发票列表完成");
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(JobConstant.CREDIT_ACCOUNT_SNAPSHOT)
    public ReturnT<String> creditAccountSnapshot(String param) {
        XxlJobLogger.log("creditAccountSnapshot 参数:{}",param);
        try {
            creditAccountService.creditAccountSnapshot(param);
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(JobConstant.ACCOUNT_SNAPSHOT)
    public ReturnT<String> accountSnapshot(String param) {
        XxlJobLogger.log("accountSnapshot 参数:{}",param);
        try {
            accountService.accountSnapshot(param);
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }
    @XxlJob(JobConstant.ACCOUNT_JOURNAL_GENERATE)
    public ReturnT<String> accountJournalGenerate(String param) {
        long tenantId=-1L;
        if(tenantClientProvider.getSessionTenant()!=null){
            tenantId=tenantClientProvider.getSessionTenant().getId();
        }
        XxlJobLogger.log("会计分录生成定时任务，开始执行,租户id:{}",tenantId);
        XxlJobLogger.log("会计分录生成定时任务，开始执行,参数:{}",param);
        List<Long> engineIds=null;
        if(!StringUtils.isBlank(param)){
            String[] paramary = param.split(",");
            engineIds = Arrays.stream(paramary).map(v -> Long.valueOf(v)).collect(Collectors.toList());
        }
        try {
            journalGenerateService.generateJournal(engineIds);
        } catch (Exception e) {
            XxlJobLogger.log("会计分录生成定时任务，执行异常：" + e.getMessage());
            return ReturnT.FAIL;
        }
        XxlJobLogger.log("会计分录生成定时任务，执行结束");
        return ReturnT.SUCCESS;
    }

    /**
     * 定时自动生成应收单
     * @param param
     * @return
     */
    @XxlJob(JobConstant.AUTO_CREATE_AR_ORDER)
    public ReturnT<String> autoCreateArOrder(String param) {
        XxlJobLogger.log("自动生成应收单定时任务 参数:{}",param);

        try {
            arOrderService.jobAutoCreate(param);
        } catch (Exception e) {
            XxlJobLogger.log("自动生成应收单定时任务执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 逻辑性库存流水定时自动生成对应财务单据(应收单与应付单)
     * @param param
     * @return
     */
    @XxlJob(JobConstant.LOGIC_INV_IO_CREATE_AP_AR_ORDER)
    public ReturnT<String> logicInvIoCreateApArOrder(String param) {
        XxlJobLogger.log("逻辑性库存流水定生成对应财务单据(应收单与应付单)定时任务 参数:{}",param);

        try {
            apArOrderService.logicInvIoJobAutoCreateApArOrder(param);
        } catch (Exception e) {
            XxlJobLogger.log("逻辑性库存流水定生成对应财务单据(应收单与应付单)定时任务执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 信用账户自动还款定时任务
     * @param param
     * @return
     */
    @XxlJob(JobConstant.CREDIT_ACCOUNT_AUTO_REPAYMENT)
    public ReturnT<String> creditAccountAutoRepayment(String param) {
        XxlJobLogger.log("信用账户自动还款定时任务 参数:{}",param);
        try {
            creditAccountAutoRepaymentService.creditAccountAutoRepayment(param);
        } catch (Exception e) {
            XxlJobLogger.log("信用账户自动还款定时任务执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 信用账户自动还款定时任务
     * @param param
     * @return
     */
    @XxlJob(JobConstant.REFRESH_AP_ORDER_VER_STATE)
    public ReturnT<String> refreshApOrderVerState(String param) {
        XxlJobLogger.log("刷新应付单核销状态任务 参数:{}",param);
        try {
            ApOrderRefreshParam apOrderJobParam = new ApOrderRefreshParam();
            apArOrderService.refreshApOrderVerState(apOrderJobParam);
        } catch (Exception e) {
            XxlJobLogger.log("刷新应付单核销状态定时任务执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }


    /**
     * 账单自动红冲
     * @param param
     * @return
     */
    @XxlJob(JobConstant.FINANCIAL_BILL_AUTO_RED)
    public ReturnT<String> autoRed(String param) {
        XxlJobLogger.log("开始执行账单红冲 参数:{}",param);
        try {
            financialBillService.autoRed();
        } catch (Exception e) {
            XxlJobLogger.log("开始执行账单红冲执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }
}
