package com.elitesland.fin.entity.invoice;

import com.elitescloud.cloudt.common.base.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Entity
@Table(name = "invoice_await_d")
@org.hibernate.annotations.Table(appliesTo = "invoice_await_d", comment = "待开发票明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "待开发票明细表", description = "待开发票明细表")
@Where(clause = "delete_flag = 0")
public class InvoiceAwaitDDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @Column(name = "line_no", columnDefinition = "int(11) comment '明细行号'")
    private Integer lineNo;

    @ApiModelProperty("商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @ApiModelProperty("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;

    @ApiModelProperty("商品编码")
    @Column(name = "item_name", columnDefinition = "varchar(64) comment '商品名称'")
    private String itemName;

    @ApiModelProperty("税收分类编码")
    @Column(name = "tax_type", columnDefinition = "varchar(32) comment '税收分类编码'")
    private String taxType;

    @Column(name = "service_name", columnDefinition = "varchar(32) comment '应税货物或劳务、服务名称'")
    private String serviceName;

    @ApiModelProperty("商品规格")
    @Column(name = "item_spec", columnDefinition = "varchar(32) comment '规格'")
    private String itemSpec;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '单位'")
    private String uom;

    @Column(name = "qty", columnDefinition = "decimal(18,8) comment '数量'")
    private BigDecimal qty;

    @Column(name = "originAmt", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal originAmt;

    @Column(name = "amt", columnDefinition = "DECIMAL(20,8) comment '含税金额'")
    private BigDecimal amt;

    @Column(name = "tax_rate", columnDefinition = "DECIMAL(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "tax", columnDefinition = "DECIMAL(20,8) comment '税额'")
    private BigDecimal tax;

    @Column(name = "net_amt", columnDefinition = "DECIMAL(20,8) comment '不含税金额'")
    private BigDecimal netAmt;

    @ApiModelProperty("返利冲抵金额")
    @Column(name = "fl_deduction_amt", columnDefinition = "DECIMAL(20,8) comment '返利冲抵金额'")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    @Column(name = "inv_discount_amt", columnDefinition = "DECIMAL(20,8) comment '票扣含税金额'")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    @Column(name = "discount_amt", columnDefinition = "DECIMAL(20,8) comment '折扣额'")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    @Column(name = "inv_amt", columnDefinition = "DECIMAL(20,8) comment '可开票含税金额'")
    private BigDecimal invAmt;

    @ApiModelProperty("发/收货单号")
    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '收/发货单号'")
    private String docNo;

    @ApiModelProperty("发货/收货单明细id")
    @Column(name = "relate_doc_did", columnDefinition = "bigint(20) comment '收/发货单明细id'")
    private Long relateDocDid;

    @ApiModelProperty("来源单据明细表ID")
    @Column(name = "opt_doc_dtl_id", columnDefinition = "bigint(20) comment '来源单据明细表ID'")
    private Long optDocDtlId;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '客户姓名'")
    private String custName;

    @ApiModelProperty("发货日期")
    @Column(name = "ship_time", columnDefinition = "datetime(6) comment '发货日期'")
    private LocalDateTime shipTime;

    @ApiModelProperty("签收日期")
    @Column(name = "confirm_time", columnDefinition = "datetime(6) comment '签收日期'")
    private LocalDateTime confirmTime;

    @ApiModelProperty("销/退订单号")
    @Column(name = "logis_doc_no", columnDefinition = "varchar(64) comment '销/退订单号'")
    private String logisDocNo;

    @ApiModelProperty("订单类型")
    @Column(name = "relate_doc_type", columnDefinition = "varchar(32) comment '订单类型'")
    private String relateDocType;

    @ApiModelProperty("订单日期")
    @Column(name = "so_date", columnDefinition = "datetime(6) comment '订单日期'")
    private LocalDateTime soDate;

    @ApiModelProperty("下单渠道类型")
    @Column(name = "so_source", columnDefinition = "varchar(32) comment '下单渠道类型'")
    private String soSource;

    @ApiModelProperty("是否赠品")
    @Column(name = "gifts_flag", columnDefinition = "varchar(32) comment '是否赠品'")
    private String giftsFlag;

    @ApiModelProperty("本次对账数量")
    @Column(name = "soa_qty", columnDefinition = "decimal(18,8) comment '本次对账数量'")
    private BigDecimal soaQty;

    @ApiModelProperty("折扣后主含税单价")
    @Column(name = "discount_price", columnDefinition = "decimal(18,8) comment '折扣后主含税单价'")
    private BigDecimal discountPrice;


    @ApiModelProperty("发票折扣率")
    @Column(name = "inv_discount", columnDefinition = "decimal(18,8) comment '发票折扣率'")
    private BigDecimal invDiscount;

    @ApiModelProperty("可开票税额")
    @Column(name = "inv_tax_amt", columnDefinition = "decimal(18,8) comment '可开票税额'")
    private BigDecimal invTaxAmt;

    @ApiModelProperty("可开票未税金额")
    @Column(name = "inv_net_amt", columnDefinition = "decimal(18,8) comment '可开票未税金额'")
    private BigDecimal invNetAmt;

    @ApiModelProperty("原主含税单价")
    @Column(name = "main_price", columnDefinition = "decimal(18,8) comment '原主含税单价'")
    private BigDecimal mainPrice;

    @ApiModelProperty("单品折扣")
    @Column(name = "item_discount", columnDefinition = "decimal(18,8) comment '单品折扣'")
    private BigDecimal itemDiscount;


    @ApiModelProperty("业务员员工名字")
    @Column(name = "agent_name", columnDefinition = "varchar(32) comment '业务员员工名字'")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    @Column(name = "agent_emp_id", columnDefinition = "bigint(64) comment '业务员员工ID'")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    @Column(name = "recv_contact_name", columnDefinition = "varchar(32) comment '收货联系人'")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    @Column(name = "recv_contact_tel", columnDefinition = "varchar(32) comment '收货联系电话'")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    @Column(name = "recv_detailaddr", columnDefinition = "varchar(128) comment '收货详细地址'")
    private String recvDetailaddr;

}
