/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.account;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountIocConvert;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.vo.account.AccountIocParamVO;
import com.elitesland.fin.domain.service.account.AccountIocDomainService;
import com.elitesland.fin.entity.account.AccountIoc;
import com.elitesland.fin.entity.account.AccountIocDO;
import com.elitesland.fin.repo.account.AccountIocRepo;
import com.elitesland.fin.repo.account.AccountIocRepoProc;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AccountIocDomainServiceImpl
implements AccountIocDomainService {
    private static final Logger log = LoggerFactory.getLogger(AccountIocDomainServiceImpl.class);
    private final AccountIocRepo accountIocRepo;
    private final AccountIocRepoProc accountIocRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<AccountIocDTO> search(AccountIocParamVO param) {
        PagingVO<AccountIocDTO> pagingVo = this.accountIocRepoProc.search(param);
        return pagingVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveAccountIoc(AccountIoc accountIoc, Optional<AccountIocDTO> optional) {
        if (optional.isPresent()) {
            AccountIocDTO accountIocDTO = optional.get();
            accountIoc.setIoCode(accountIocDTO.getIoCode());
            accountIoc.setId(accountIocDTO.getId());
            accountIoc.setCreator(accountIocDTO.getCreator());
            accountIoc.setCreateUserId(accountIocDTO.getCreateUserId());
            accountIoc.setCreateTime(accountIocDTO.getCreateTime());
            accountIoc.setModifyTime(LocalDateTime.now());
        } else {
            accountIoc.setId(null);
            accountIoc.setCreator(null);
            accountIoc.setCreateUserId(null);
            accountIoc.setCreateTime(LocalDateTime.now());
            accountIoc.setModifyUserId(null);
            accountIoc.setUpdater(null);
            accountIoc.setModifyTime(LocalDateTime.now());
        }
        AccountIocDO accountIocDO = AccountIocConvert.INSTANCE.enToDo(accountIoc);
        Long id = ((AccountIocDO)this.accountIocRepo.save(accountIocDO)).getId();
        return id;
    }

    @Override
    @SysCodeProc
    public Optional<AccountIocDTO> findById(Long id) {
        return this.accountIocRepo.findById(id).map(AccountIocConvert.INSTANCE::doToDto);
    }

    @Override
    @SysCodeProc
    public Optional<AccountIocDTO> findByCode(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return Optional.empty();
        }
        AccountIocParamVO param = new AccountIocParamVO();
        param.setIoCode(code);
        JPAQuery<AccountIocDTO> jpaQuery = this.accountIocRepoProc.select(param);
        return Optional.of((AccountIocDTO)jpaQuery.fetchFirst());
    }

    @Override
    @SysCodeProc
    public List<AccountIocDTO> findByIdBatch(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.EMPTY_LIST;
        }
        List<AccountIocDTO> whAreaSettingDTOList = this.accountIocRepo.findAllById(idList).stream().map(AccountIocConvert.INSTANCE::doToDto).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(whAreaSettingDTOList)) {
            return Collections.EMPTY_LIST;
        }
        return whAreaSettingDTOList;
    }

    @Override
    @SysCodeProc
    public List<AccountIocDTO> findByCodeBatch(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.EMPTY_LIST;
        }
        AccountIocParamVO param = new AccountIocParamVO();
        param.setIoCodeList(codeList);
        JPAQuery<AccountIocDTO> jpaQuery = this.accountIocRepoProc.select(param);
        List accountIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)accountIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return accountIocDTOS;
    }

    @Override
    @SysCodeProc
    public List<AccountIocDTO> selectByParam(AccountIocParamVO param) {
        JPAQuery<AccountIocDTO> jpaQuery = this.accountIocRepoProc.select(param);
        List accountIocDTOS = jpaQuery.fetch();
        if (CollectionUtils.isEmpty((Collection)accountIocDTOS)) {
            return Collections.EMPTY_LIST;
        }
        return accountIocDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        this.accountIocRepoProc.updateDeleteFlagByIds(deleteFlag, idList).execute();
    }

    @Override
    public List<AccountIocDTO> queryByAccountIocParam(AccountIocParam accountIocParam) {
        return this.accountIocRepoProc.queryByAccountIocParam(accountIocParam);
    }

    public AccountIocDomainServiceImpl(AccountIocRepo accountIocRepo, AccountIocRepoProc accountIocRepoProc) {
        this.accountIocRepo = accountIocRepo;
        this.accountIocRepoProc = accountIocRepoProc;
    }
}

