package com.elitesland.fin.application.facade.dto.flowrepair;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/08
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "accountFlowRepairHandle20DTO",description = "账户流水修复重算处理计算20DTO")
public class AccountFlowRepairHandle20DTO  implements Serializable {
    private static final long serialVersionUID = -6168790589584989516L;

    @ApiModelProperty(value = "流水表的ID")
    private Long flowId;

    @ApiModelProperty(value = "流水表的流水号")
    private String flowNo;

    @ApiModelProperty(value = "原流水发生金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "账户类型")
    private String accountType;

    @ApiModelProperty(value = "账户编码")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    private String accountName;

    @ApiModelProperty("交易类型")
    private String transactionType;

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("来源单号")
    private String sourceNo;


    @ApiModelProperty("账户金额")
    private BigDecimal accountAmount;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accountOccupancyAmount;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accountAvailableAmount;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditDate;


    @ApiModelProperty("前一条账户占用金额")
    private BigDecimal prevAccountOccupancyAmount;

    @ApiModelProperty("前一条账户金额")
    private BigDecimal prevAccountAmount;

    @ApiModelProperty(value = "前一条流水表的流水号")
    private String prevFlowNo;

    @ApiModelProperty(value = "前一条审核时间")
    private LocalDateTime prevAuditDate;


    @ApiModelProperty("和前一条金额差值")
    private BigDecimal differenceValue;


    @ApiModelProperty(value = "重算原因 [UDC]yst-fin:FLOW_RECALCUL_REASON")
    private String recalculationReason;

    @ApiModelProperty(value = "重算日期")
    private LocalDateTime recalculationDate;
}
